% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableOpenXlsxStyle.R
\docType{class}
\name{TableOpenXlsxStyle}
\alias{TableOpenXlsxStyle}
\title{A class that specifies Excel styling as used by the openxlsx package.}
\format{\code{\link{R6Class}} object.}
\value{
Object of \code{\link{R6Class}} with properties and methods that help
  define styles.
}
\description{
The TableOpenXlsxStyle class specifies the styling for cells in an
Excel worksheet.
}
\section{Fields}{

\describe{
\item{\code{parentTable}}{Owning table.}

\item{\code{baseStyleName}}{The name of the base style in the table.}

\item{\code{isBaseStyle}}{TRUE when this style is the equivalent of a named style in
the table, FALSE if this style has additional settings over and above
the base style of the same name.}

\item{\code{fontName}}{The name of the font (single font name, not a CSS style
list).}

\item{\code{fontSize}}{The size of the font (units: point).}

\item{\code{bold}}{TRUE if text is bold.}

\item{\code{italic}}{TRUE if text is italic.}

\item{\code{underline}}{TRUE if text is underlined.}

\item{\code{strikethrough}}{TRUE if text has a line through it.}

\item{\code{superscript}}{TRUE if text is small and raised.}

\item{\code{subscript}}{TRUE if text is small and lowered.}

\item{\code{fillColor}}{The background colour for the cell (as a hex value, e.g.
#00FF00).}

\item{\code{textColor}}{The color of the text (as a hex value).}

\item{\code{hAlign}}{The horizontal alignment of the text:  left, center or right.}

\item{\code{vAlign}}{The vertical alignment of the text:  top, middle or bottom.}

\item{\code{wrapText}}{TRUE if the text is allowed to wrap onto multiple lines.}

\item{\code{textRotation}}{The rotation angle of the text or 255 for vertical.}

\item{\code{border}}{A list (with elements style and color) specifying the border
settings for all four sides of each cell at once.}

\item{\code{borderLeft}}{A list (with elements style and color) specifying the
border settings for the left border of each cell.}

\item{\code{borderRight}}{A list (with elements style and color) specifying the
border settings for the right border of each cell.}

\item{\code{borderTop}}{A list (with elements style and color) specifying the border
settings for the top border of each cell.}

\item{\code{borderBottom}}{A list (with elements style and color) specifying the
border settings for the bottom border of each cell.}

\item{\code{valueFormat}}{The Excel formatting applied to the field value.  One of
the following values: GENERAL, NUMBER, CURRENCY, ACCOUNTING, DATE,
LONGDATE, TIME, PERCENTAGE, FRACTION, SCIENTIFIC, TEXT, COMMA. Or for
dates/datetimes, a combination of d, m, y. Or for numeric values, use 0.00
etc.}

\item{\code{minColumnWidth}}{The minimum width of this column.}

\item{\code{minRowHeight}}{The minimum height of this row.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(...)}}{Create a new Excel style, specifying the field
  values documented above.}

  \item{\code{isBasicStyleNameMatch(baseStyleName=NULL)}}{Find a matching
  base style by name.}
  \item{\code{isFullStyleDetailMatch = function(baseStyleName=NULL,
  isBaseStyle=NULL, fontName=NULL, fontSize=NULL, bold=NULL, italic=NULL,
  underline=NULL, strikethrough=NULL, superscript=NULL, subscript=NULL,
  fillColor=NULL, textColor=NULL, hAlign=NULL, vAlign=NULL, wrapText=NULL,
  textRotation=NULL, indent=NULL, borderAll=NULL, borderLeft=NULL,
  borderRight=NULL, borderTop=NULL, borderBottom=NULL, valueFormat=NULL,
  minColumnWidth=NULL, minRowHeight=NULL}}{Find a matching style matching on
  all the attributes of the style.}
  \item{\code{createOpenXslxStyle()}}{Create the openxlsx style.}
  \item{\code{asList()}}{Get a list representation of this style.}
  \item{\code{asJSON()}}{Get a JSON representation of this style.}
  \item{\code{asString()}}{Get a text representation of this style.}
}
}

\examples{
# This class should not be used by end users.  It is an internal class
# created only by the BasicTable class.  It is used when rendering to Excel.
library(basictabler)
tbl <- qtbl(data.frame(a=1:2, b=3:4))
library(openxlsx)
wb <- createWorkbook(creator = Sys.getenv("USERNAME"))
addWorksheet(wb, "Data")
tbl$writeToExcelWorksheet(wb=wb, wsName="Data",
                         topRowNumber=1, leftMostColumnNumber=1,
                         applyStyles=TRUE, mapStylesFromCSS=TRUE)
# Use saveWorkbook() to save the Excel file.
}
