% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BasicTable.R
\docType{class}
\name{BasicTable}
\alias{BasicTable}
\title{A class that defines a basic table.}
\format{\code{\link{R6Class}} object.}
\usage{
BasicTable
}
\value{
Object of \code{\link{R6Class}} with properties and methods that
  define a basic table.
}
\description{
The BasicTable class represents a table with styling and formatting that can
be rendered to multiple output formats.
}
\section{Fields}{

\describe{
\item{\code{argumentCheckMode}}{A number (0-4 meaning none, minimal, basic,
balanced, full) indicating the argument checking level.}

\item{\code{traceEnabled}}{A logical value indicating whether actions are logged to
a trace file.}

\item{\code{rowCount}}{The number of rows in the table.}

\item{\code{columnCount}}{The number of columns in the table.}

\item{\code{cells}}{A TableCells object containing all of the cells in the body of
the table.}

\item{\code{theme}}{The name of the theme currently applied to the table.}

\item{\code{styles}}{A TableStyles object containing the styles used to theme the
table.}

\item{\code{allowExternalStyles}}{Enable support for external styles, when producing
content for external systems.}

\item{\code{allTimings}}{The time taken for various activities related to
constructing the table.}

\item{\code{significantTimings}}{The time taken for various activities related to
constructing the table, where the elapsed time > 0.1 seconds.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(argumentCheckMode="auto", theme=NULL,
  replaceExistingStyles=FALSE, tableStyle=NULL, headingStyle=NULL,
  cellStyle=NULL, totalStyle=NULL, compatibility=NULL, traceEnabled=FALSE,
  traceFile=NULL)}}{Create a new table, optionally specifying the name of a
  built in theme or CSS style declarations for the different cells within the
  table.}
  \item{\code{addData(dataFrame=NULL, columnNamesAsColumnHeaders=TRUE,
  explicitColumnHeaders=NULL, rowNamesAsRowHeaders=FALSE,
  firstColumnAsRowHeaders=FALSE, explicitRowHeaders=NULL, columnFormats=NULL,
  baseStyleNames=NULL)}}{Generate the table from a data frame, specifying
  headers and value formatting.}
  \item{\code{addMatrix(matrix=NULL, columnNamesAsColumnHeaders=TRUE,
  explicitColumnHeaders=NULL, rowNamesAsRowHeaders=FALSE,
  explicitRowHeaders=NULL, columnFormats=NULL,
  baseStyleNames=NULL)}}{Generate the table from a matrix, specifying headers
  and value formatting.l}
  \item{\code{mergeCells(rFrom, cFrom, rSpan=NULL, cSpan=NULL,
  rTo=NULL, cTo=NULL)}}{Merge cells in the table.  This does not delete
  the other cells covered by the merged cell.  When the table is output, the
  top-left most cell in the merged cell range is rendered over the other
  cells (which are effectively hidden).}
  \item{\code{unmergeCells(r, c, errorIfNotFound=TRUE)}}{Delete a merged cell
  range by specifying any of the cells covered by the merged cell.}
  \item{\code{applyCellMerges()}}{Updates the isMerged, isMergeRoot and
  mergeIndex properties of the cells.}
  \item{\code{formatValue(value=NULL, format=NULL)}}{Format a value for
  display, using either sprintf(), format() or a custom formatting function.}
  \item{\code{addStyle(styleName, declarations)}}{Define a new TableStyle and
  add it to the TableStyles collection.}
  \item{\code{createInlineStyle(baseStyleName, declarations)}}{Create a
  TableStyle object that can be used to style individual cells in the table.}
  \item{\code{setStyling(rFrom=NULL, cFrom=NULL, rTo=NULL, cTo=NULL,
  cells=NULL, baseStyleName=NULL, style=NULL, declarations=NULL)}}{Set the
  style settings across a range of cells.}
  \item{\code{resetCells()}}{Clear the cells of the table.}
  \item{\code{getCells(specifyCellsAsList=TRUE, rowNumbers=NULL,
  columnNumbers=NULL, cellCoordinates=NULL)}}{Retrieve cells by a combination
  of row and/or column numbers.}
  \item{\code{findCells(rowNumbers=NULL, columnNumbers=NULL,
  minValue=NULL, maxValue=NULL, exactValues=NULL, includeNull=TRUE,
  includeNA=TRUE)}}{Find cells in the body of the table matching
  the specified criteria.}
  \item{\code{print(asCharacter=FALSE)}}{Either print the table to the
  console or retrieve it as a character value.}
  \item{\code{asMatrix(firstRowAsColumnNames=FALSE,
  firstColumnAsRowNames=FALSE, rawValue=FALSE)}}{Gets the table as
  a matrix, with or without headings.}
  \item{\code{asDataFrame(firstRowAsColumnNames=FALSE,
  firstColumnAsRowNames=FALSE, rawValue=FALSE)}}{Gets the table as a data
  frame, with or without headings.}
  \item{\code{getCss(styleNamePrefix)}}{Get the CSS declarations for the
  entire table.}
  \item{\code{getHtml(styleNamePrefix)}}{Get the HTML representation of the
  table, specifying the CSS style name prefix to use.}
  \item{\code{saveHtml(filePath, fullPageHTML=TRUE, styleNamePrefix)}}{Save
  the HTML representation of the table to a file.}
  \item{\code{renderTable(width, height, styleNamePrefix)}}{Render the table
  as a htmlwidget.}
  \item{\code{writeToExcelWorksheet(wb=NULL, wsName=NULL, topRowNumber=NULL,
  leftMostColumnNumber=NULL, mapStylesFromCSS=TRUE)}}{Output the table
  into the specified workbook and worksheet at the specified row-column
  location.}
  \item{\code{asList()}}{Get a list representation of the table.}
  \item{\code{asJSON()}}{Get a JSON representation of the table.}
  \item{\code{viewJSON()}}{View the JSON representation of the table.}
}
}

\examples{
# The package vignettes have many more examples of working with the
# BasicTable class.
# Quickly rendering a table as an htmlwidget:
library(basictabler)
qhtbl(data.frame(a=1:2, b=3:4))
# Rendering a larger table as an htmlwidget:
library(basictabler)
library(dplyr)
tocsummary <- bhmsummary \%>\%
  group_by(TOC) \%>\%
  summarise(OnTimeArrivals=sum(OnTimeArrivals),
            OnTimeDepartures=sum(OnTimeDepartures),
            TotalTrains=sum(TrainCount)) \%>\%
  ungroup() \%>\%
  mutate(OnTimeArrivalPercent=OnTimeArrivals/TotalTrains*100,
         OnTimeDeparturePercent=OnTimeDepartures/TotalTrains*100) \%>\%
  arrange(TOC)

tbl <- BasicTable$new()
columnHeaders <- c("TOC", "On-Time Arrivals", "On-Time Departures",
  "Total Trains", "On-Time Arrival \%", "On-Time Departure \%")
columnFormats=list()
columnFormats[[2]] <- list(big.mark=",")
columnFormats[[3]] <- list(big.mark=",")
columnFormats[[4]] <- list(big.mark=",")
columnFormats[[5]] <- "\%.1f"
columnFormats[[6]] <- "\%.1f"
tbl$addData(tocsummary, columnNamesAsColumnHeaders=FALSE,
  firstColumnAsRowHeaders=TRUE,
  explicitColumnHeaders=columnHeaders, columnFormats=columnFormats)
tbl$renderTable()
}
\keyword{datasets}
