% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vintPlot.R
\name{vintPlot}
\alias{vintPlot}
\title{vintPlot}
\usage{
vintPlot(trees, plotType = "barplot", top = NULL)
}
\arguments{
\item{trees}{A data frame created by `extractTreeData` function.}

\item{plotType}{Which type of plot to return. Either a barplot 'barplot' with the
quantiles shown as a line, a point plot with the quantiles shown as a gradient 'point', or a
letter-value plot 'lvp'.}

\item{top}{Display only the top X metrics (does not apply to the letter-value plot).}
}
\value{
A plot of variable importance.
}
\description{
Plot the pair-wise variable interactions inclusion porportions
for a BART model with the 25% and 75% quantile.
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
 # Load the dbarts package to access the bart function
 library(dbarts)
 # Get Data
 df <- na.omit(airquality)
 # Create Simple dbarts Model For Regression:
 set.seed(1701)
 dbartModel <- bart(df[2:6], df[, 1], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)

 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = df)
 vintPlot(trees = trees_data, top = 5)
}
}
