% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsroc.R
\name{bsroc}
\alias{bsroc}
\title{bsroc}
\usage{
bsroc(m, level = c(0.05, 0.5, 0.95), title = "Bayesian SROC Curve",
  fpr.x = seq(0.01, 0.99, 0.01), partial.AUC = TRUE, xlim.bsroc = c(0, 1),
  ylim.bsroc = c(0, 1), lower.auc = 0, upper.auc = 0.99,
  col.fill.points = "blue", results.bauc = TRUE, results.bsroc = FALSE,
  plot.post.bauc = FALSE, bins = 30, scale.size.area = 10)
}
\arguments{
\item{m}{The object generated by metadiag.}

\item{level}{Credibility levels of the predictive curve}

\item{title}{Optional parameter for setting a title in the plot.}

\item{fpr.x}{Grid of values where the conditionl distribution is calculated.}

\item{partial.AUC}{Automatically calculate the AUC for the observed range of FPRs, default is TRUE.}

\item{xlim.bsroc}{Limits of the x-axis for the BSROC curve plot.}

\item{ylim.bsroc}{Limits of the y-axis for the BSROC curve plot.}

\item{lower.auc}{Lower limit of the AUC.}

\item{upper.auc}{Upper limit of the AUC.}

\item{col.fill.points}{Color used to fill points, default is blue.}

\item{results.bauc}{Print results of the Bayesian Area Under the Curve, default value is TRUE.}

\item{results.bsroc}{Print results of the Bayesian SROC curve, default value is FALSE.}

\item{plot.post.bauc}{The BSROC and the posterior of the BAUC are ploted in the same page, default is FALSE.}

\item{bins}{Histograms' bins.}

\item{scale.size.area}{Scale area for the ploted points, default = 10.}
}
\description{
This function plots the observed data in the ROC (Receiving Operating Charachteristics) space with the
Bayesian SROC (Summary ROC) curve. The predictive curves are approximated using a parametric model.
}
\examples{

## execute analysis
\dontrun{
data(glas)
glas.t <- glas[glas$marker == "Telomerase", 1:4]
glas.m1 <- metadiag(glas.t, re = "normal", link = "logit")
bsroc(glas.m1)
bsroc(glas.m1, plot.post.bauc = TRUE)

In this example the range of the observed FPR is less than 20\%.
Calculating the BSROC curve makes no sense! You will get a warning message!

data(mri)
mri.m <- metadiag(mri)
bsroc(mri.m)
}
}
\seealso{
\code{\link{metadiag}}.
}
\keyword{file}

