% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba-per-game-stats-per-poss.R
\name{NBAPerGameStatisticsPer100Poss}
\alias{NBAPerGameStatisticsPer100Poss}
\title{NBA Player Statistics For a Given Season per 100 Possessions}
\usage{
NBAPerGameStatisticsPer100Poss(season = 2018)
}
\arguments{
\item{season}{A numeric year}
}
\value{
An object of class tbl_df
}
\description{
This function returns all player statistics per 100 possessions for each
player from an NBA season on basketball-reference.com.  See an example
table at:
https://www.basketball-reference.com/leagues/NBA_2018_per_poss.html
}
\examples{
library(magrittr)

players <- NBAPerGameStatisticsPer100Poss(season = 2018)
players

players \%>\%
  dplyr::filter(pos \%in\% c("SF")) \%>\%
  dplyr::select(player, link) \%>\%
  dplyr::distinct()

}
