// Generated by rstantools.  Do not edit by hand.

/*
    trystan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    trystan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with trystan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_MCMC_NSS2_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_MCMC_NSS2");
    reader.add_event(140, 138, "end", "model_MCMC_NSS2");
    return reader;
}
#include <stan_meta_header.hpp>
class model_MCMC_NSS2
  : public stan::model::model_base_crtp<model_MCMC_NSS2> {
private:
        int NE;
        int NF;
        std::vector<int> TP;
        std::vector<int> MT;
        int nMT;
        std::vector<int> FE;
        std::vector<int> num_mut;
        std::vector<int> num_obs;
        std::vector<int> R;
        std::vector<double> U_cont;
        int nrep;
        std::vector<double> tl;
        std::vector<std::vector<double> > Avg_Reads;
        int Chase;
public:
    model_MCMC_NSS2(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_MCMC_NSS2(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_MCMC_NSS2_namespace::model_MCMC_NSS2";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "NE", "int", context__.to_vec());
            NE = int(0);
            vals_i__ = context__.vals_i("NE");
            pos__ = 0;
            NE = vals_i__[pos__++];
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "NF", "int", context__.to_vec());
            NF = int(0);
            vals_i__ = context__.vals_i("NF");
            pos__ = 0;
            NF = vals_i__[pos__++];
            current_statement_begin__ = 5;
            validate_non_negative_index("TP", "NE", NE);
            context__.validate_dims("data initialization", "TP", "int", context__.to_vec(NE));
            TP = std::vector<int>(NE, int(0));
            vals_i__ = context__.vals_i("TP");
            pos__ = 0;
            size_t TP_k_0_max__ = NE;
            for (size_t k_0__ = 0; k_0__ < TP_k_0_max__; ++k_0__) {
                TP[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 6;
            validate_non_negative_index("MT", "NE", NE);
            context__.validate_dims("data initialization", "MT", "int", context__.to_vec(NE));
            MT = std::vector<int>(NE, int(0));
            vals_i__ = context__.vals_i("MT");
            pos__ = 0;
            size_t MT_k_0_max__ = NE;
            for (size_t k_0__ = 0; k_0__ < MT_k_0_max__; ++k_0__) {
                MT[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "nMT", "int", context__.to_vec());
            nMT = int(0);
            vals_i__ = context__.vals_i("nMT");
            pos__ = 0;
            nMT = vals_i__[pos__++];
            current_statement_begin__ = 8;
            validate_non_negative_index("FE", "NE", NE);
            context__.validate_dims("data initialization", "FE", "int", context__.to_vec(NE));
            FE = std::vector<int>(NE, int(0));
            vals_i__ = context__.vals_i("FE");
            pos__ = 0;
            size_t FE_k_0_max__ = NE;
            for (size_t k_0__ = 0; k_0__ < FE_k_0_max__; ++k_0__) {
                FE[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("num_mut", "NE", NE);
            context__.validate_dims("data initialization", "num_mut", "int", context__.to_vec(NE));
            num_mut = std::vector<int>(NE, int(0));
            vals_i__ = context__.vals_i("num_mut");
            pos__ = 0;
            size_t num_mut_k_0_max__ = NE;
            for (size_t k_0__ = 0; k_0__ < num_mut_k_0_max__; ++k_0__) {
                num_mut[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 10;
            validate_non_negative_index("num_obs", "NE", NE);
            context__.validate_dims("data initialization", "num_obs", "int", context__.to_vec(NE));
            num_obs = std::vector<int>(NE, int(0));
            vals_i__ = context__.vals_i("num_obs");
            pos__ = 0;
            size_t num_obs_k_0_max__ = NE;
            for (size_t k_0__ = 0; k_0__ < num_obs_k_0_max__; ++k_0__) {
                num_obs[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 11;
            validate_non_negative_index("R", "NE", NE);
            context__.validate_dims("data initialization", "R", "int", context__.to_vec(NE));
            R = std::vector<int>(NE, int(0));
            vals_i__ = context__.vals_i("R");
            pos__ = 0;
            size_t R_k_0_max__ = NE;
            for (size_t k_0__ = 0; k_0__ < R_k_0_max__; ++k_0__) {
                R[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 12;
            validate_non_negative_index("U_cont", "NE", NE);
            context__.validate_dims("data initialization", "U_cont", "double", context__.to_vec(NE));
            U_cont = std::vector<double>(NE, double(0));
            vals_r__ = context__.vals_r("U_cont");
            pos__ = 0;
            size_t U_cont_k_0_max__ = NE;
            for (size_t k_0__ = 0; k_0__ < U_cont_k_0_max__; ++k_0__) {
                U_cont[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 13;
            context__.validate_dims("data initialization", "nrep", "int", context__.to_vec());
            nrep = int(0);
            vals_i__ = context__.vals_i("nrep");
            pos__ = 0;
            nrep = vals_i__[pos__++];
            current_statement_begin__ = 14;
            validate_non_negative_index("tl", "nMT", nMT);
            context__.validate_dims("data initialization", "tl", "double", context__.to_vec(nMT));
            tl = std::vector<double>(nMT, double(0));
            vals_r__ = context__.vals_r("tl");
            pos__ = 0;
            size_t tl_k_0_max__ = nMT;
            for (size_t k_0__ = 0; k_0__ < tl_k_0_max__; ++k_0__) {
                tl[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 15;
            validate_non_negative_index("Avg_Reads", "NF", NF);
            validate_non_negative_index("Avg_Reads", "nMT", nMT);
            context__.validate_dims("data initialization", "Avg_Reads", "double", context__.to_vec(NF,nMT));
            Avg_Reads = std::vector<std::vector<double> >(NF, std::vector<double>(nMT, double(0)));
            vals_r__ = context__.vals_r("Avg_Reads");
            pos__ = 0;
            size_t Avg_Reads_k_0_max__ = NF;
            size_t Avg_Reads_k_1_max__ = nMT;
            for (size_t k_1__ = 0; k_1__ < Avg_Reads_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < Avg_Reads_k_0_max__; ++k_0__) {
                    Avg_Reads[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 16;
            context__.validate_dims("data initialization", "Chase", "int", context__.to_vec());
            Chase = int(0);
            vals_i__ = context__.vals_i("Chase");
            pos__ = 0;
            Chase = vals_i__[pos__++];
            check_greater_or_equal(function__, "Chase", Chase, 0);
            check_less_or_equal(function__, "Chase", Chase, 1);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 20;
            validate_non_negative_index("TL_lambda_eff", "nrep", nrep);
            validate_non_negative_index("TL_lambda_eff", "nMT", nMT);
            num_params_r__ += (nrep * nMT);
            current_statement_begin__ = 21;
            validate_non_negative_index("log_lambda_o", "nrep", nrep);
            validate_non_negative_index("log_lambda_o", "nMT", nMT);
            num_params_r__ += (nrep * nMT);
            current_statement_begin__ = 22;
            validate_non_negative_index("alpha", "nMT", nMT);
            validate_non_negative_index("alpha", "NF", NF);
            num_params_r__ += (nMT * NF);
            current_statement_begin__ = 23;
            validate_non_negative_index("mu_fn", "nMT", nMT);
            num_params_r__ += (1 * nMT);
            current_statement_begin__ = 24;
            validate_non_negative_index("sig_fn", "nMT", nMT);
            num_params_r__ += (1 * nMT);
            current_statement_begin__ = 25;
            validate_non_negative_index("z_fn", "NF", NF);
            validate_non_negative_index("z_fn", "nMT", nMT);
            validate_non_negative_index("z_fn", "nrep", nrep);
            num_params_r__ += (((1 * NF) * nMT) * nrep);
            current_statement_begin__ = 27;
            validate_non_negative_index("a", "nMT", nMT);
            num_params_r__ += nMT;
            current_statement_begin__ = 28;
            validate_non_negative_index("b", "nMT", nMT);
            num_params_r__ += nMT;
            current_statement_begin__ = 29;
            validate_non_negative_index("z_sd_r", "nMT", nMT);
            validate_non_negative_index("z_sd_r", "NF", NF);
            num_params_r__ += (nMT * NF);
            current_statement_begin__ = 30;
            validate_non_negative_index("sig_rep", "nMT", nMT);
            num_params_r__ += nMT;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_MCMC_NSS2() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 20;
        if (!(context__.contains_r("TL_lambda_eff")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable TL_lambda_eff missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("TL_lambda_eff");
        pos__ = 0U;
        validate_non_negative_index("TL_lambda_eff", "nrep", nrep);
        validate_non_negative_index("TL_lambda_eff", "nMT", nMT);
        context__.validate_dims("parameter initialization", "TL_lambda_eff", "vector_d", context__.to_vec(nMT,nrep));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > TL_lambda_eff(nMT, Eigen::Matrix<double, Eigen::Dynamic, 1>(nrep));
        size_t TL_lambda_eff_j_1_max__ = nrep;
        size_t TL_lambda_eff_k_0_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < TL_lambda_eff_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < TL_lambda_eff_k_0_max__; ++k_0__) {
                TL_lambda_eff[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t TL_lambda_eff_i_0_max__ = nMT;
        for (size_t i_0__ = 0; i_0__ < TL_lambda_eff_i_0_max__; ++i_0__) {
            try {
                writer__.vector_lb_unconstrain(0, TL_lambda_eff[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable TL_lambda_eff: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 21;
        if (!(context__.contains_r("log_lambda_o")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable log_lambda_o missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("log_lambda_o");
        pos__ = 0U;
        validate_non_negative_index("log_lambda_o", "nrep", nrep);
        validate_non_negative_index("log_lambda_o", "nMT", nMT);
        context__.validate_dims("parameter initialization", "log_lambda_o", "vector_d", context__.to_vec(nMT,nrep));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > log_lambda_o(nMT, Eigen::Matrix<double, Eigen::Dynamic, 1>(nrep));
        size_t log_lambda_o_j_1_max__ = nrep;
        size_t log_lambda_o_k_0_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < log_lambda_o_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < log_lambda_o_k_0_max__; ++k_0__) {
                log_lambda_o[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t log_lambda_o_i_0_max__ = nMT;
        for (size_t i_0__ = 0; i_0__ < log_lambda_o_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(log_lambda_o[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable log_lambda_o: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 22;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        validate_non_negative_index("alpha", "nMT", nMT);
        validate_non_negative_index("alpha", "NF", NF);
        context__.validate_dims("parameter initialization", "alpha", "vector_d", context__.to_vec(NF,nMT));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > alpha(NF, Eigen::Matrix<double, Eigen::Dynamic, 1>(nMT));
        size_t alpha_j_1_max__ = nMT;
        size_t alpha_k_0_max__ = NF;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
                alpha[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t alpha_i_0_max__ = NF;
        for (size_t i_0__ = 0; i_0__ < alpha_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(alpha[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 23;
        if (!(context__.contains_r("mu_fn")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_fn missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_fn");
        pos__ = 0U;
        validate_non_negative_index("mu_fn", "nMT", nMT);
        context__.validate_dims("parameter initialization", "mu_fn", "double", context__.to_vec(nMT));
        std::vector<double> mu_fn(nMT, double(0));
        size_t mu_fn_k_0_max__ = nMT;
        for (size_t k_0__ = 0; k_0__ < mu_fn_k_0_max__; ++k_0__) {
            mu_fn[k_0__] = vals_r__[pos__++];
        }
        size_t mu_fn_i_0_max__ = nMT;
        for (size_t i_0__ = 0; i_0__ < mu_fn_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(mu_fn[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_fn: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 24;
        if (!(context__.contains_r("sig_fn")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sig_fn missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sig_fn");
        pos__ = 0U;
        validate_non_negative_index("sig_fn", "nMT", nMT);
        context__.validate_dims("parameter initialization", "sig_fn", "double", context__.to_vec(nMT));
        std::vector<double> sig_fn(nMT, double(0));
        size_t sig_fn_k_0_max__ = nMT;
        for (size_t k_0__ = 0; k_0__ < sig_fn_k_0_max__; ++k_0__) {
            sig_fn[k_0__] = vals_r__[pos__++];
        }
        size_t sig_fn_i_0_max__ = nMT;
        for (size_t i_0__ = 0; i_0__ < sig_fn_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sig_fn[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sig_fn: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 25;
        if (!(context__.contains_r("z_fn")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z_fn missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z_fn");
        pos__ = 0U;
        validate_non_negative_index("z_fn", "NF", NF);
        validate_non_negative_index("z_fn", "nMT", nMT);
        validate_non_negative_index("z_fn", "nrep", nrep);
        context__.validate_dims("parameter initialization", "z_fn", "double", context__.to_vec(NF,nMT,nrep));
        std::vector<std::vector<std::vector<double> > > z_fn(NF, std::vector<std::vector<double> >(nMT, std::vector<double>(nrep, double(0))));
        size_t z_fn_k_0_max__ = NF;
        size_t z_fn_k_1_max__ = nMT;
        size_t z_fn_k_2_max__ = nrep;
        for (size_t k_2__ = 0; k_2__ < z_fn_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < z_fn_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < z_fn_k_0_max__; ++k_0__) {
                    z_fn[k_0__][k_1__][k_2__] = vals_r__[pos__++];
                }
            }
        }
        size_t z_fn_i_0_max__ = NF;
        size_t z_fn_i_1_max__ = nMT;
        size_t z_fn_i_2_max__ = nrep;
        for (size_t i_0__ = 0; i_0__ < z_fn_i_0_max__; ++i_0__) {
            for (size_t i_1__ = 0; i_1__ < z_fn_i_1_max__; ++i_1__) {
                for (size_t i_2__ = 0; i_2__ < z_fn_i_2_max__; ++i_2__) {
                    try {
                        writer__.scalar_unconstrain(z_fn[i_0__][i_1__][i_2__]);
                    } catch (const std::exception& e) {
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z_fn: ") + e.what()), current_statement_begin__, prog_reader__());
                    }
                }
            }
        }
        current_statement_begin__ = 27;
        if (!(context__.contains_r("a")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable a missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("a");
        pos__ = 0U;
        validate_non_negative_index("a", "nMT", nMT);
        context__.validate_dims("parameter initialization", "a", "vector_d", context__.to_vec(nMT));
        Eigen::Matrix<double, Eigen::Dynamic, 1> a(nMT);
        size_t a_j_1_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            a(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, a);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable a: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 28;
        if (!(context__.contains_r("b")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable b missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("b");
        pos__ = 0U;
        validate_non_negative_index("b", "nMT", nMT);
        context__.validate_dims("parameter initialization", "b", "vector_d", context__.to_vec(nMT));
        Eigen::Matrix<double, Eigen::Dynamic, 1> b(nMT);
        size_t b_j_1_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
            b(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(b);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable b: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 29;
        if (!(context__.contains_r("z_sd_r")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z_sd_r missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z_sd_r");
        pos__ = 0U;
        validate_non_negative_index("z_sd_r", "nMT", nMT);
        validate_non_negative_index("z_sd_r", "NF", NF);
        context__.validate_dims("parameter initialization", "z_sd_r", "vector_d", context__.to_vec(NF,nMT));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > z_sd_r(NF, Eigen::Matrix<double, Eigen::Dynamic, 1>(nMT));
        size_t z_sd_r_j_1_max__ = nMT;
        size_t z_sd_r_k_0_max__ = NF;
        for (size_t j_1__ = 0; j_1__ < z_sd_r_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < z_sd_r_k_0_max__; ++k_0__) {
                z_sd_r[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t z_sd_r_i_0_max__ = NF;
        for (size_t i_0__ = 0; i_0__ < z_sd_r_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(z_sd_r[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z_sd_r: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 30;
        if (!(context__.contains_r("sig_rep")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sig_rep missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sig_rep");
        pos__ = 0U;
        validate_non_negative_index("sig_rep", "nMT", nMT);
        context__.validate_dims("parameter initialization", "sig_rep", "vector_d", context__.to_vec(nMT));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sig_rep(nMT);
        size_t sig_rep_j_1_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < sig_rep_j_1_max__; ++j_1__) {
            sig_rep(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, sig_rep);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sig_rep: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 20;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > TL_lambda_eff;
            size_t TL_lambda_eff_d_0_max__ = nMT;
            TL_lambda_eff.reserve(TL_lambda_eff_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < TL_lambda_eff_d_0_max__; ++d_0__) {
                if (jacobian__)
                    TL_lambda_eff.push_back(in__.vector_lb_constrain(0, nrep, lp__));
                else
                    TL_lambda_eff.push_back(in__.vector_lb_constrain(0, nrep));
            }
            current_statement_begin__ = 21;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > log_lambda_o;
            size_t log_lambda_o_d_0_max__ = nMT;
            log_lambda_o.reserve(log_lambda_o_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < log_lambda_o_d_0_max__; ++d_0__) {
                if (jacobian__)
                    log_lambda_o.push_back(in__.vector_constrain(nrep, lp__));
                else
                    log_lambda_o.push_back(in__.vector_constrain(nrep));
            }
            current_statement_begin__ = 22;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > alpha;
            size_t alpha_d_0_max__ = NF;
            alpha.reserve(alpha_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < alpha_d_0_max__; ++d_0__) {
                if (jacobian__)
                    alpha.push_back(in__.vector_constrain(nMT, lp__));
                else
                    alpha.push_back(in__.vector_constrain(nMT));
            }
            current_statement_begin__ = 23;
            std::vector<local_scalar_t__> mu_fn;
            size_t mu_fn_d_0_max__ = nMT;
            mu_fn.reserve(mu_fn_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < mu_fn_d_0_max__; ++d_0__) {
                if (jacobian__)
                    mu_fn.push_back(in__.scalar_constrain(lp__));
                else
                    mu_fn.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 24;
            std::vector<local_scalar_t__> sig_fn;
            size_t sig_fn_d_0_max__ = nMT;
            sig_fn.reserve(sig_fn_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sig_fn_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sig_fn.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sig_fn.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 25;
            std::vector<std::vector<std::vector<local_scalar_t__> > > z_fn;
            size_t z_fn_d_0_max__ = NF;
            size_t z_fn_d_1_max__ = nMT;
            size_t z_fn_d_2_max__ = nrep;
            z_fn.resize(z_fn_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < z_fn_d_0_max__; ++d_0__) {
                z_fn[d_0__].resize(z_fn_d_1_max__);
                for (size_t d_1__ = 0; d_1__ < z_fn_d_1_max__; ++d_1__) {
                    z_fn[d_0__][d_1__].reserve(z_fn_d_2_max__);
                    for (size_t d_2__ = 0; d_2__ < z_fn_d_2_max__; ++d_2__) {
                        if (jacobian__)
                            z_fn[d_0__][d_1__].push_back(in__.scalar_constrain(lp__));
                        else
                            z_fn[d_0__][d_1__].push_back(in__.scalar_constrain());
                    }
                }
            }
            current_statement_begin__ = 27;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> a;
            (void) a;  // dummy to suppress unused var warning
            if (jacobian__)
                a = in__.vector_lb_constrain(0, nMT, lp__);
            else
                a = in__.vector_lb_constrain(0, nMT);
            current_statement_begin__ = 28;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b;
            (void) b;  // dummy to suppress unused var warning
            if (jacobian__)
                b = in__.vector_constrain(nMT, lp__);
            else
                b = in__.vector_constrain(nMT);
            current_statement_begin__ = 29;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > z_sd_r;
            size_t z_sd_r_d_0_max__ = NF;
            z_sd_r.reserve(z_sd_r_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < z_sd_r_d_0_max__; ++d_0__) {
                if (jacobian__)
                    z_sd_r.push_back(in__.vector_constrain(nMT, lp__));
                else
                    z_sd_r.push_back(in__.vector_constrain(nMT));
            }
            current_statement_begin__ = 30;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sig_rep;
            (void) sig_rep;  // dummy to suppress unused var warning
            if (jacobian__)
                sig_rep = in__.vector_lb_constrain(0, nMT, lp__);
            else
                sig_rep = in__.vector_lb_constrain(0, nMT);
            // transformed parameters
            current_statement_begin__ = 35;
            validate_non_negative_index("frac_new", "NF", NF);
            validate_non_negative_index("frac_new", "nMT", nMT);
            validate_non_negative_index("frac_new", "nrep", nrep);
            std::vector<std::vector<std::vector<local_scalar_t__> > > frac_new(NF, std::vector<std::vector<local_scalar_t__> >(nMT, std::vector<local_scalar_t__>(nrep, local_scalar_t__(0))));
            stan::math::initialize(frac_new, DUMMY_VAR__);
            stan::math::fill(frac_new, DUMMY_VAR__);
            current_statement_begin__ = 36;
            validate_non_negative_index("mu_rep_logit_fn", "NF", NF);
            validate_non_negative_index("mu_rep_logit_fn", "nMT", nMT);
            validate_non_negative_index("mu_rep_logit_fn", "nrep", nrep);
            std::vector<std::vector<std::vector<local_scalar_t__> > > mu_rep_logit_fn(NF, std::vector<std::vector<local_scalar_t__> >(nMT, std::vector<local_scalar_t__>(nrep, local_scalar_t__(0))));
            stan::math::initialize(mu_rep_logit_fn, DUMMY_VAR__);
            stan::math::fill(mu_rep_logit_fn, DUMMY_VAR__);
            current_statement_begin__ = 37;
            validate_non_negative_index("log_lambda_n", "nrep", nrep);
            validate_non_negative_index("log_lambda_n", "nMT", nMT);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > log_lambda_n(nMT, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nrep));
            stan::math::initialize(log_lambda_n, DUMMY_VAR__);
            stan::math::fill(log_lambda_n, DUMMY_VAR__);
            current_statement_begin__ = 38;
            validate_non_negative_index("sd_r_mu", "nMT", nMT);
            validate_non_negative_index("sd_r_mu", "NF", NF);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > sd_r_mu(NF, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nMT));
            stan::math::initialize(sd_r_mu, DUMMY_VAR__);
            stan::math::fill(sd_r_mu, DUMMY_VAR__);
            current_statement_begin__ = 39;
            validate_non_negative_index("sd_rep", "nMT", nMT);
            validate_non_negative_index("sd_rep", "NF", NF);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > sd_rep(NF, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nMT));
            stan::math::initialize(sd_rep, DUMMY_VAR__);
            stan::math::fill(sd_rep, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 41;
            for (int m = 1; m <= nMT; ++m) {
                current_statement_begin__ = 42;
                for (int r = 1; r <= nrep; ++r) {
                    current_statement_begin__ = 43;
                    stan::model::assign(log_lambda_n, 
                                stan::model::cons_list(stan::model::index_uni(m), stan::model::cons_list(stan::model::index_uni(r), stan::model::nil_index_list())), 
                                (get_base1(get_base1(log_lambda_o, m, "log_lambda_o", 1), r, "log_lambda_o", 2) + get_base1(get_base1(TL_lambda_eff, m, "TL_lambda_eff", 1), r, "TL_lambda_eff", 2)), 
                                "assigning variable log_lambda_n");
                }
            }
            current_statement_begin__ = 48;
            for (int i = 1; i <= NF; ++i) {
                current_statement_begin__ = 49;
                for (int j = 1; j <= nMT; ++j) {
                    current_statement_begin__ = 50;
                    stan::model::assign(sd_rep, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                ((-(get_base1(a, j, "a", 1)) * get_base1(get_base1(Avg_Reads, i, "Avg_Reads", 1), j, "Avg_Reads", 2)) + get_base1(b, j, "b", 1)), 
                                "assigning variable sd_rep");
                    current_statement_begin__ = 51;
                    stan::model::assign(sd_r_mu, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                stan::math::exp((get_base1(get_base1(sd_rep, i, "sd_rep", 1), j, "sd_rep", 2) + (get_base1(get_base1(z_sd_r, i, "z_sd_r", 1), j, "z_sd_r", 2) * get_base1(sig_rep, j, "sig_rep", 1)))), 
                                "assigning variable sd_r_mu");
                    current_statement_begin__ = 55;
                    for (int k = 1; k <= nrep; ++k) {
                        current_statement_begin__ = 56;
                        stan::model::assign(mu_rep_logit_fn, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()))), 
                                    (get_base1(get_base1(alpha, i, "alpha", 1), j, "alpha", 2) + (get_base1(get_base1(sd_r_mu, i, "sd_r_mu", 1), j, "sd_r_mu", 2) * get_base1(get_base1(get_base1(z_fn, i, "z_fn", 1), j, "z_fn", 2), k, "z_fn", 3))), 
                                    "assigning variable mu_rep_logit_fn");
                        current_statement_begin__ = 57;
                        stan::model::assign(frac_new, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()))), 
                                    inv_logit(get_base1(get_base1(get_base1(mu_rep_logit_fn, i, "mu_rep_logit_fn", 1), j, "mu_rep_logit_fn", 2), k, "mu_rep_logit_fn", 3)), 
                                    "assigning variable frac_new");
                    }
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 35;
            size_t frac_new_k_0_max__ = NF;
            size_t frac_new_k_1_max__ = nMT;
            size_t frac_new_k_2_max__ = nrep;
            for (size_t k_0__ = 0; k_0__ < frac_new_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < frac_new_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < frac_new_k_2_max__; ++k_2__) {
                        if (stan::math::is_uninitialized(frac_new[k_0__][k_1__][k_2__])) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: frac_new" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable frac_new: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            size_t frac_new_i_0_max__ = NF;
            size_t frac_new_i_1_max__ = nMT;
            size_t frac_new_i_2_max__ = nrep;
            for (size_t i_0__ = 0; i_0__ < frac_new_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < frac_new_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < frac_new_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "frac_new[i_0__][i_1__][i_2__]", frac_new[i_0__][i_1__][i_2__], 0);
                        check_less_or_equal(function__, "frac_new[i_0__][i_1__][i_2__]", frac_new[i_0__][i_1__][i_2__], 1);
                    }
                }
            }
            current_statement_begin__ = 36;
            size_t mu_rep_logit_fn_k_0_max__ = NF;
            size_t mu_rep_logit_fn_k_1_max__ = nMT;
            size_t mu_rep_logit_fn_k_2_max__ = nrep;
            for (size_t k_0__ = 0; k_0__ < mu_rep_logit_fn_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < mu_rep_logit_fn_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < mu_rep_logit_fn_k_2_max__; ++k_2__) {
                        if (stan::math::is_uninitialized(mu_rep_logit_fn[k_0__][k_1__][k_2__])) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: mu_rep_logit_fn" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu_rep_logit_fn: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 37;
            size_t log_lambda_n_k_0_max__ = nMT;
            size_t log_lambda_n_j_1_max__ = nrep;
            for (size_t k_0__ = 0; k_0__ < log_lambda_n_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < log_lambda_n_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(log_lambda_n[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: log_lambda_n" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable log_lambda_n: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 38;
            size_t sd_r_mu_k_0_max__ = NF;
            size_t sd_r_mu_j_1_max__ = nMT;
            for (size_t k_0__ = 0; k_0__ < sd_r_mu_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < sd_r_mu_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(sd_r_mu[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: sd_r_mu" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sd_r_mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            size_t sd_r_mu_i_0_max__ = NF;
            for (size_t i_0__ = 0; i_0__ < sd_r_mu_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "sd_r_mu[i_0__]", sd_r_mu[i_0__], 0);
            }
            current_statement_begin__ = 39;
            size_t sd_rep_k_0_max__ = NF;
            size_t sd_rep_j_1_max__ = nMT;
            for (size_t k_0__ = 0; k_0__ < sd_rep_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < sd_rep_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(sd_rep[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: sd_rep" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sd_rep: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            current_statement_begin__ = 66;
            lp_accum__.add(normal_log<propto__>(mu_fn, 0, 1.25));
            current_statement_begin__ = 67;
            lp_accum__.add(lognormal_log<propto__>(sig_fn, -(1), 0.5));
            current_statement_begin__ = 69;
            lp_accum__.add(normal_log<propto__>(a, 0.3, 0.2));
            current_statement_begin__ = 70;
            lp_accum__.add(normal_log<propto__>(b, -(1.5), 0.35));
            current_statement_begin__ = 73;
            for (int m = 1; m <= nMT; ++m) {
                current_statement_begin__ = 74;
                lp_accum__.add(lognormal_log<propto__>(get_base1(TL_lambda_eff, m, "TL_lambda_eff", 1), 1.4, 0.15));
                current_statement_begin__ = 75;
                lp_accum__.add(normal_log<propto__>(get_base1(log_lambda_o, m, "log_lambda_o", 1), -(3.5), 0.5));
            }
            current_statement_begin__ = 78;
            lp_accum__.add(lognormal_log<propto__>(sig_rep, -(2), 0.25));
            current_statement_begin__ = 80;
            for (int i = 1; i <= NF; ++i) {
                current_statement_begin__ = 85;
                lp_accum__.add(normal_log<propto__>(get_base1(z_sd_r, i, "z_sd_r", 1), 0, 1));
                current_statement_begin__ = 86;
                for (int j = 1; j <= nMT; ++j) {
                    current_statement_begin__ = 87;
                    lp_accum__.add(normal_log<propto__>(get_base1(get_base1(alpha, i, "alpha", 1), j, "alpha", 2), get_base1(mu_fn, j, "mu_fn", 1), get_base1(sig_fn, j, "sig_fn", 1)));
                    current_statement_begin__ = 90;
                    lp_accum__.add(normal_log<propto__>(get_base1(get_base1(z_fn, i, "z_fn", 1), j, "z_fn", 2), 0, 1));
                }
            }
            current_statement_begin__ = 99;
            for (int i = 1; i <= NE; ++i) {
                current_statement_begin__ = 100;
                lp_accum__.add((get_base1(num_obs, i, "num_obs", 1) * log_mix((get_base1(TP, i, "TP", 1) * get_base1(get_base1(get_base1(frac_new, get_base1(FE, i, "FE", 1), "frac_new", 1), get_base1(MT, i, "MT", 1), "frac_new", 2), get_base1(R, i, "R", 1), "frac_new", 3)), poisson_log_log(get_base1(num_mut, i, "num_mut", 1), (get_base1(U_cont, i, "U_cont", 1) + get_base1(get_base1(log_lambda_n, get_base1(MT, i, "MT", 1), "log_lambda_n", 1), get_base1(R, i, "R", 1), "log_lambda_n", 2))), poisson_log_log(get_base1(num_mut, i, "num_mut", 1), (get_base1(U_cont, i, "U_cont", 1) + get_base1(get_base1(log_lambda_o, get_base1(MT, i, "MT", 1), "log_lambda_o", 1), get_base1(R, i, "R", 1), "log_lambda_o", 2))))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("TL_lambda_eff");
        names__.push_back("log_lambda_o");
        names__.push_back("alpha");
        names__.push_back("mu_fn");
        names__.push_back("sig_fn");
        names__.push_back("z_fn");
        names__.push_back("a");
        names__.push_back("b");
        names__.push_back("z_sd_r");
        names__.push_back("sig_rep");
        names__.push_back("frac_new");
        names__.push_back("mu_rep_logit_fn");
        names__.push_back("log_lambda_n");
        names__.push_back("sd_r_mu");
        names__.push_back("sd_rep");
        names__.push_back("kd");
        names__.push_back("L2FC_kd");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nMT);
        dims__.push_back(nrep);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nMT);
        dims__.push_back(nrep);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NF);
        dims__.push_back(nMT);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nMT);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nMT);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NF);
        dims__.push_back(nMT);
        dims__.push_back(nrep);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nMT);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nMT);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NF);
        dims__.push_back(nMT);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nMT);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NF);
        dims__.push_back(nMT);
        dims__.push_back(nrep);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NF);
        dims__.push_back(nMT);
        dims__.push_back(nrep);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nMT);
        dims__.push_back(nrep);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NF);
        dims__.push_back(nMT);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NF);
        dims__.push_back(nMT);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NF);
        dims__.push_back(nMT);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NF);
        dims__.push_back((nMT - 1));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_MCMC_NSS2_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > TL_lambda_eff;
        size_t TL_lambda_eff_d_0_max__ = nMT;
        TL_lambda_eff.reserve(TL_lambda_eff_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < TL_lambda_eff_d_0_max__; ++d_0__) {
            TL_lambda_eff.push_back(in__.vector_lb_constrain(0, nrep));
        }
        size_t TL_lambda_eff_j_1_max__ = nrep;
        size_t TL_lambda_eff_k_0_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < TL_lambda_eff_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < TL_lambda_eff_k_0_max__; ++k_0__) {
                vars__.push_back(TL_lambda_eff[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > log_lambda_o;
        size_t log_lambda_o_d_0_max__ = nMT;
        log_lambda_o.reserve(log_lambda_o_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < log_lambda_o_d_0_max__; ++d_0__) {
            log_lambda_o.push_back(in__.vector_constrain(nrep));
        }
        size_t log_lambda_o_j_1_max__ = nrep;
        size_t log_lambda_o_k_0_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < log_lambda_o_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < log_lambda_o_k_0_max__; ++k_0__) {
                vars__.push_back(log_lambda_o[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > alpha;
        size_t alpha_d_0_max__ = NF;
        alpha.reserve(alpha_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < alpha_d_0_max__; ++d_0__) {
            alpha.push_back(in__.vector_constrain(nMT));
        }
        size_t alpha_j_1_max__ = nMT;
        size_t alpha_k_0_max__ = NF;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
                vars__.push_back(alpha[k_0__](j_1__));
            }
        }
        std::vector<double> mu_fn;
        size_t mu_fn_d_0_max__ = nMT;
        mu_fn.reserve(mu_fn_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < mu_fn_d_0_max__; ++d_0__) {
            mu_fn.push_back(in__.scalar_constrain());
        }
        size_t mu_fn_k_0_max__ = nMT;
        for (size_t k_0__ = 0; k_0__ < mu_fn_k_0_max__; ++k_0__) {
            vars__.push_back(mu_fn[k_0__]);
        }
        std::vector<double> sig_fn;
        size_t sig_fn_d_0_max__ = nMT;
        sig_fn.reserve(sig_fn_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sig_fn_d_0_max__; ++d_0__) {
            sig_fn.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sig_fn_k_0_max__ = nMT;
        for (size_t k_0__ = 0; k_0__ < sig_fn_k_0_max__; ++k_0__) {
            vars__.push_back(sig_fn[k_0__]);
        }
        std::vector<std::vector<std::vector<double> > > z_fn;
        size_t z_fn_d_0_max__ = NF;
        size_t z_fn_d_1_max__ = nMT;
        size_t z_fn_d_2_max__ = nrep;
        z_fn.resize(z_fn_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < z_fn_d_0_max__; ++d_0__) {
            z_fn[d_0__].resize(z_fn_d_1_max__);
            for (size_t d_1__ = 0; d_1__ < z_fn_d_1_max__; ++d_1__) {
                z_fn[d_0__][d_1__].reserve(z_fn_d_2_max__);
                for (size_t d_2__ = 0; d_2__ < z_fn_d_2_max__; ++d_2__) {
                    z_fn[d_0__][d_1__].push_back(in__.scalar_constrain());
                }
            }
        }
        size_t z_fn_k_0_max__ = NF;
        size_t z_fn_k_1_max__ = nMT;
        size_t z_fn_k_2_max__ = nrep;
        for (size_t k_2__ = 0; k_2__ < z_fn_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < z_fn_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < z_fn_k_0_max__; ++k_0__) {
                    vars__.push_back(z_fn[k_0__][k_1__][k_2__]);
                }
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> a = in__.vector_lb_constrain(0, nMT);
        size_t a_j_1_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            vars__.push_back(a(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> b = in__.vector_constrain(nMT);
        size_t b_j_1_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
            vars__.push_back(b(j_1__));
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > z_sd_r;
        size_t z_sd_r_d_0_max__ = NF;
        z_sd_r.reserve(z_sd_r_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < z_sd_r_d_0_max__; ++d_0__) {
            z_sd_r.push_back(in__.vector_constrain(nMT));
        }
        size_t z_sd_r_j_1_max__ = nMT;
        size_t z_sd_r_k_0_max__ = NF;
        for (size_t j_1__ = 0; j_1__ < z_sd_r_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < z_sd_r_k_0_max__; ++k_0__) {
                vars__.push_back(z_sd_r[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> sig_rep = in__.vector_lb_constrain(0, nMT);
        size_t sig_rep_j_1_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < sig_rep_j_1_max__; ++j_1__) {
            vars__.push_back(sig_rep(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 35;
            validate_non_negative_index("frac_new", "NF", NF);
            validate_non_negative_index("frac_new", "nMT", nMT);
            validate_non_negative_index("frac_new", "nrep", nrep);
            std::vector<std::vector<std::vector<double> > > frac_new(NF, std::vector<std::vector<double> >(nMT, std::vector<double>(nrep, double(0))));
            stan::math::initialize(frac_new, DUMMY_VAR__);
            stan::math::fill(frac_new, DUMMY_VAR__);
            current_statement_begin__ = 36;
            validate_non_negative_index("mu_rep_logit_fn", "NF", NF);
            validate_non_negative_index("mu_rep_logit_fn", "nMT", nMT);
            validate_non_negative_index("mu_rep_logit_fn", "nrep", nrep);
            std::vector<std::vector<std::vector<double> > > mu_rep_logit_fn(NF, std::vector<std::vector<double> >(nMT, std::vector<double>(nrep, double(0))));
            stan::math::initialize(mu_rep_logit_fn, DUMMY_VAR__);
            stan::math::fill(mu_rep_logit_fn, DUMMY_VAR__);
            current_statement_begin__ = 37;
            validate_non_negative_index("log_lambda_n", "nrep", nrep);
            validate_non_negative_index("log_lambda_n", "nMT", nMT);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > log_lambda_n(nMT, Eigen::Matrix<double, Eigen::Dynamic, 1>(nrep));
            stan::math::initialize(log_lambda_n, DUMMY_VAR__);
            stan::math::fill(log_lambda_n, DUMMY_VAR__);
            current_statement_begin__ = 38;
            validate_non_negative_index("sd_r_mu", "nMT", nMT);
            validate_non_negative_index("sd_r_mu", "NF", NF);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > sd_r_mu(NF, Eigen::Matrix<double, Eigen::Dynamic, 1>(nMT));
            stan::math::initialize(sd_r_mu, DUMMY_VAR__);
            stan::math::fill(sd_r_mu, DUMMY_VAR__);
            current_statement_begin__ = 39;
            validate_non_negative_index("sd_rep", "nMT", nMT);
            validate_non_negative_index("sd_rep", "NF", NF);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > sd_rep(NF, Eigen::Matrix<double, Eigen::Dynamic, 1>(nMT));
            stan::math::initialize(sd_rep, DUMMY_VAR__);
            stan::math::fill(sd_rep, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 41;
            for (int m = 1; m <= nMT; ++m) {
                current_statement_begin__ = 42;
                for (int r = 1; r <= nrep; ++r) {
                    current_statement_begin__ = 43;
                    stan::model::assign(log_lambda_n, 
                                stan::model::cons_list(stan::model::index_uni(m), stan::model::cons_list(stan::model::index_uni(r), stan::model::nil_index_list())), 
                                (get_base1(get_base1(log_lambda_o, m, "log_lambda_o", 1), r, "log_lambda_o", 2) + get_base1(get_base1(TL_lambda_eff, m, "TL_lambda_eff", 1), r, "TL_lambda_eff", 2)), 
                                "assigning variable log_lambda_n");
                }
            }
            current_statement_begin__ = 48;
            for (int i = 1; i <= NF; ++i) {
                current_statement_begin__ = 49;
                for (int j = 1; j <= nMT; ++j) {
                    current_statement_begin__ = 50;
                    stan::model::assign(sd_rep, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                ((-(get_base1(a, j, "a", 1)) * get_base1(get_base1(Avg_Reads, i, "Avg_Reads", 1), j, "Avg_Reads", 2)) + get_base1(b, j, "b", 1)), 
                                "assigning variable sd_rep");
                    current_statement_begin__ = 51;
                    stan::model::assign(sd_r_mu, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                stan::math::exp((get_base1(get_base1(sd_rep, i, "sd_rep", 1), j, "sd_rep", 2) + (get_base1(get_base1(z_sd_r, i, "z_sd_r", 1), j, "z_sd_r", 2) * get_base1(sig_rep, j, "sig_rep", 1)))), 
                                "assigning variable sd_r_mu");
                    current_statement_begin__ = 55;
                    for (int k = 1; k <= nrep; ++k) {
                        current_statement_begin__ = 56;
                        stan::model::assign(mu_rep_logit_fn, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()))), 
                                    (get_base1(get_base1(alpha, i, "alpha", 1), j, "alpha", 2) + (get_base1(get_base1(sd_r_mu, i, "sd_r_mu", 1), j, "sd_r_mu", 2) * get_base1(get_base1(get_base1(z_fn, i, "z_fn", 1), j, "z_fn", 2), k, "z_fn", 3))), 
                                    "assigning variable mu_rep_logit_fn");
                        current_statement_begin__ = 57;
                        stan::model::assign(frac_new, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()))), 
                                    inv_logit(get_base1(get_base1(get_base1(mu_rep_logit_fn, i, "mu_rep_logit_fn", 1), j, "mu_rep_logit_fn", 2), k, "mu_rep_logit_fn", 3)), 
                                    "assigning variable frac_new");
                    }
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 35;
            size_t frac_new_i_0_max__ = NF;
            size_t frac_new_i_1_max__ = nMT;
            size_t frac_new_i_2_max__ = nrep;
            for (size_t i_0__ = 0; i_0__ < frac_new_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < frac_new_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < frac_new_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "frac_new[i_0__][i_1__][i_2__]", frac_new[i_0__][i_1__][i_2__], 0);
                        check_less_or_equal(function__, "frac_new[i_0__][i_1__][i_2__]", frac_new[i_0__][i_1__][i_2__], 1);
                    }
                }
            }
            current_statement_begin__ = 38;
            size_t sd_r_mu_i_0_max__ = NF;
            for (size_t i_0__ = 0; i_0__ < sd_r_mu_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "sd_r_mu[i_0__]", sd_r_mu[i_0__], 0);
            }
            // write transformed parameters
            if (include_tparams__) {
                size_t frac_new_k_0_max__ = NF;
                size_t frac_new_k_1_max__ = nMT;
                size_t frac_new_k_2_max__ = nrep;
                for (size_t k_2__ = 0; k_2__ < frac_new_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < frac_new_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < frac_new_k_0_max__; ++k_0__) {
                            vars__.push_back(frac_new[k_0__][k_1__][k_2__]);
                        }
                    }
                }
                size_t mu_rep_logit_fn_k_0_max__ = NF;
                size_t mu_rep_logit_fn_k_1_max__ = nMT;
                size_t mu_rep_logit_fn_k_2_max__ = nrep;
                for (size_t k_2__ = 0; k_2__ < mu_rep_logit_fn_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < mu_rep_logit_fn_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < mu_rep_logit_fn_k_0_max__; ++k_0__) {
                            vars__.push_back(mu_rep_logit_fn[k_0__][k_1__][k_2__]);
                        }
                    }
                }
                size_t log_lambda_n_j_1_max__ = nrep;
                size_t log_lambda_n_k_0_max__ = nMT;
                for (size_t j_1__ = 0; j_1__ < log_lambda_n_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < log_lambda_n_k_0_max__; ++k_0__) {
                        vars__.push_back(log_lambda_n[k_0__](j_1__));
                    }
                }
                size_t sd_r_mu_j_1_max__ = nMT;
                size_t sd_r_mu_k_0_max__ = NF;
                for (size_t j_1__ = 0; j_1__ < sd_r_mu_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < sd_r_mu_k_0_max__; ++k_0__) {
                        vars__.push_back(sd_r_mu[k_0__](j_1__));
                    }
                }
                size_t sd_rep_j_1_max__ = nMT;
                size_t sd_rep_k_0_max__ = NF;
                for (size_t j_1__ = 0; j_1__ < sd_rep_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < sd_rep_k_0_max__; ++k_0__) {
                        vars__.push_back(sd_rep[k_0__](j_1__));
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 108;
            validate_non_negative_index("kd", "nMT", nMT);
            validate_non_negative_index("kd", "NF", NF);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > kd(NF, Eigen::Matrix<double, Eigen::Dynamic, 1>(nMT));
            stan::math::initialize(kd, DUMMY_VAR__);
            stan::math::fill(kd, DUMMY_VAR__);
            current_statement_begin__ = 109;
            validate_non_negative_index("L2FC_kd", "(nMT - 1)", (nMT - 1));
            validate_non_negative_index("L2FC_kd", "NF", NF);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > L2FC_kd(NF, Eigen::Matrix<double, Eigen::Dynamic, 1>((nMT - 1)));
            stan::math::initialize(L2FC_kd, DUMMY_VAR__);
            stan::math::fill(L2FC_kd, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 111;
            for (int i = 1; i <= NF; ++i) {
                current_statement_begin__ = 112;
                for (int j = 1; j <= nMT; ++j) {
                    current_statement_begin__ = 114;
                    if (as_bool(logical_eq(Chase, 1))) {
                        current_statement_begin__ = 116;
                        stan::model::assign(kd, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                    (-(stan::math::log(inv_logit(get_base1(get_base1(alpha, i, "alpha", 1), j, "alpha", 2)))) / get_base1(tl, j, "tl", 1)), 
                                    "assigning variable kd");
                    } else {
                        current_statement_begin__ = 120;
                        stan::model::assign(kd, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                    (-(stan::math::log((1 - inv_logit(get_base1(get_base1(alpha, i, "alpha", 1), j, "alpha", 2))))) / get_base1(tl, j, "tl", 1)), 
                                    "assigning variable kd");
                    }
                }
                current_statement_begin__ = 125;
                for (int k = 1; k <= (nMT - 1); ++k) {
                    current_statement_begin__ = 126;
                    if (as_bool(logical_eq(Chase, 1))) {
                        current_statement_begin__ = 128;
                        stan::model::assign(L2FC_kd, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    (-(get_base1(get_base1(alpha, i, "alpha", 1), (k + 1), "alpha", 2)) + get_base1(get_base1(alpha, i, "alpha", 1), 1, "alpha", 2)), 
                                    "assigning variable L2FC_kd");
                    } else {
                        current_statement_begin__ = 132;
                        stan::model::assign(L2FC_kd, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(alpha, i, "alpha", 1), (k + 1), "alpha", 2) - get_base1(get_base1(alpha, i, "alpha", 1), 1, "alpha", 2)), 
                                    "assigning variable L2FC_kd");
                    }
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 108;
            size_t kd_j_1_max__ = nMT;
            size_t kd_k_0_max__ = NF;
            for (size_t j_1__ = 0; j_1__ < kd_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < kd_k_0_max__; ++k_0__) {
                    vars__.push_back(kd[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 109;
            size_t L2FC_kd_j_1_max__ = (nMT - 1);
            size_t L2FC_kd_k_0_max__ = NF;
            for (size_t j_1__ = 0; j_1__ < L2FC_kd_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < L2FC_kd_k_0_max__; ++k_0__) {
                    vars__.push_back(L2FC_kd[k_0__](j_1__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_MCMC_NSS2";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t TL_lambda_eff_j_1_max__ = nrep;
        size_t TL_lambda_eff_k_0_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < TL_lambda_eff_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < TL_lambda_eff_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "TL_lambda_eff" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lambda_o_j_1_max__ = nrep;
        size_t log_lambda_o_k_0_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < log_lambda_o_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < log_lambda_o_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_lambda_o" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t alpha_j_1_max__ = nMT;
        size_t alpha_k_0_max__ = NF;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_fn_k_0_max__ = nMT;
        for (size_t k_0__ = 0; k_0__ < mu_fn_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_fn" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sig_fn_k_0_max__ = nMT;
        for (size_t k_0__ = 0; k_0__ < sig_fn_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sig_fn" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_fn_k_0_max__ = NF;
        size_t z_fn_k_1_max__ = nMT;
        size_t z_fn_k_2_max__ = nrep;
        for (size_t k_2__ = 0; k_2__ < z_fn_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < z_fn_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < z_fn_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "z_fn" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t a_j_1_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t b_j_1_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_sd_r_j_1_max__ = nMT;
        size_t z_sd_r_k_0_max__ = NF;
        for (size_t j_1__ = 0; j_1__ < z_sd_r_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < z_sd_r_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z_sd_r" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sig_rep_j_1_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < sig_rep_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sig_rep" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t frac_new_k_0_max__ = NF;
            size_t frac_new_k_1_max__ = nMT;
            size_t frac_new_k_2_max__ = nrep;
            for (size_t k_2__ = 0; k_2__ < frac_new_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < frac_new_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < frac_new_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "frac_new" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t mu_rep_logit_fn_k_0_max__ = NF;
            size_t mu_rep_logit_fn_k_1_max__ = nMT;
            size_t mu_rep_logit_fn_k_2_max__ = nrep;
            for (size_t k_2__ = 0; k_2__ < mu_rep_logit_fn_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < mu_rep_logit_fn_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < mu_rep_logit_fn_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "mu_rep_logit_fn" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t log_lambda_n_j_1_max__ = nrep;
            size_t log_lambda_n_k_0_max__ = nMT;
            for (size_t j_1__ = 0; j_1__ < log_lambda_n_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < log_lambda_n_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "log_lambda_n" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sd_r_mu_j_1_max__ = nMT;
            size_t sd_r_mu_k_0_max__ = NF;
            for (size_t j_1__ = 0; j_1__ < sd_r_mu_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < sd_r_mu_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sd_r_mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sd_rep_j_1_max__ = nMT;
            size_t sd_rep_k_0_max__ = NF;
            for (size_t j_1__ = 0; j_1__ < sd_rep_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < sd_rep_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sd_rep" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t kd_j_1_max__ = nMT;
        size_t kd_k_0_max__ = NF;
        for (size_t j_1__ = 0; j_1__ < kd_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < kd_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "kd" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t L2FC_kd_j_1_max__ = (nMT - 1);
        size_t L2FC_kd_k_0_max__ = NF;
        for (size_t j_1__ = 0; j_1__ < L2FC_kd_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < L2FC_kd_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L2FC_kd" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t TL_lambda_eff_j_1_max__ = nrep;
        size_t TL_lambda_eff_k_0_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < TL_lambda_eff_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < TL_lambda_eff_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "TL_lambda_eff" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lambda_o_j_1_max__ = nrep;
        size_t log_lambda_o_k_0_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < log_lambda_o_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < log_lambda_o_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_lambda_o" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t alpha_j_1_max__ = nMT;
        size_t alpha_k_0_max__ = NF;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_fn_k_0_max__ = nMT;
        for (size_t k_0__ = 0; k_0__ < mu_fn_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_fn" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sig_fn_k_0_max__ = nMT;
        for (size_t k_0__ = 0; k_0__ < sig_fn_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sig_fn" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_fn_k_0_max__ = NF;
        size_t z_fn_k_1_max__ = nMT;
        size_t z_fn_k_2_max__ = nrep;
        for (size_t k_2__ = 0; k_2__ < z_fn_k_2_max__; ++k_2__) {
            for (size_t k_1__ = 0; k_1__ < z_fn_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < z_fn_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "z_fn" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t a_j_1_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t b_j_1_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_sd_r_j_1_max__ = nMT;
        size_t z_sd_r_k_0_max__ = NF;
        for (size_t j_1__ = 0; j_1__ < z_sd_r_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < z_sd_r_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z_sd_r" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sig_rep_j_1_max__ = nMT;
        for (size_t j_1__ = 0; j_1__ < sig_rep_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sig_rep" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t frac_new_k_0_max__ = NF;
            size_t frac_new_k_1_max__ = nMT;
            size_t frac_new_k_2_max__ = nrep;
            for (size_t k_2__ = 0; k_2__ < frac_new_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < frac_new_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < frac_new_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "frac_new" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t mu_rep_logit_fn_k_0_max__ = NF;
            size_t mu_rep_logit_fn_k_1_max__ = nMT;
            size_t mu_rep_logit_fn_k_2_max__ = nrep;
            for (size_t k_2__ = 0; k_2__ < mu_rep_logit_fn_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < mu_rep_logit_fn_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < mu_rep_logit_fn_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "mu_rep_logit_fn" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t log_lambda_n_j_1_max__ = nrep;
            size_t log_lambda_n_k_0_max__ = nMT;
            for (size_t j_1__ = 0; j_1__ < log_lambda_n_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < log_lambda_n_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "log_lambda_n" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sd_r_mu_j_1_max__ = nMT;
            size_t sd_r_mu_k_0_max__ = NF;
            for (size_t j_1__ = 0; j_1__ < sd_r_mu_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < sd_r_mu_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sd_r_mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sd_rep_j_1_max__ = nMT;
            size_t sd_rep_k_0_max__ = NF;
            for (size_t j_1__ = 0; j_1__ < sd_rep_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < sd_rep_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sd_rep" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t kd_j_1_max__ = nMT;
        size_t kd_k_0_max__ = NF;
        for (size_t j_1__ = 0; j_1__ < kd_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < kd_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "kd" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t L2FC_kd_j_1_max__ = (nMT - 1);
        size_t L2FC_kd_k_0_max__ = NF;
        for (size_t j_1__ = 0; j_1__ < L2FC_kd_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < L2FC_kd_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "L2FC_kd" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
}; // model
}  // namespace
typedef model_MCMC_NSS2_namespace::model_MCMC_NSS2 stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
