% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_transcription.R
\name{start_transcription}
\alias{start_transcription}
\title{Start AWS Transcribe Job}
\usage{
start_transcription(name, url, format = tools::file_ext(url),
  language = "en-US", hertz = NULL, ...)
}
\arguments{
\item{name}{A character string specifying a unique name for the transcription job.}

\item{url}{A character string specifying a URL for the media file to be transcribed.}

\item{format}{A character string specifying the file format. One of: \dQuote{mp3}, \dQuote{mp4}, \dQuote{wav}, \dQuote{flac}.}

\item{language}{A character string specifying a language code. Currently defaults to \dQuote{en-US}.}

\item{hertz}{Optionally, a numeric value specifying sample rate in Hertz.}

\item{\dots}{Additional arguments passed to \code{\link{transcribeHTTP}}.}
}
\value{
A list containing details of the job. The transcript can be retrieved with \code{\link{get_transcription}}.
}
\description{
Start an AWS Transcribe job
}
\examples{
\dontrun{
# start a transcription
## upload a file to S3
library("aws.s3")
put_object(file = "recording.mp3", bucket = "my-bucket", object = "recording.mp3")

## start trancription
start_transcription("first-example", "https://my-bucket.us-east-1.amazonaws.com/recording.mp3")
}
}
\seealso{
\code{\link{get_transcription}}
}
