% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_language.R
\name{detect_language}
\alias{detect_language}
\title{Detect language in a source text}
\usage{
detect_language(text, ...)
}
\arguments{
\item{text}{A character string containing a textual source, or a character vector to detect languages separately for each element.}

\item{\dots}{Additional arguments passed to \code{\link{comprehendHTTP}}.}
}
\value{
A data frame of language probabilities.
}
\description{
Detect language(s) in a source text
}
\examples{
\dontrun{
  # simple example
  detect_language("This is a test sentence in English")
  
  # two languages in a single text
  txt <- "A: ¡Hola! ¿Como está, usted?\nB: Ça va bien. Merci. Et toi?"
  detect_language(txt)

  # "batch" mode
  detect_language(c("A: ¡Hola! ¿Como está, usted?",
                    "B: Ça va bien. Merci. Et toi?"))
}
}
