#' @title Detect Protected Health Information (PHI) in a source medical text
#' @description Detect Protected Health Information (PHI) in a source medical text
#' @param text A character string containing a text to entities analyze, or a character vector to perform analysis separately for each element.
#' @param language A character string containing a two-letter language code. Currently only \dQuote{en} is supported.
#' @param \dots Additional arguments passed to \code{\link{comprehendHTTP}}.
#' @return A data frame
#' @examples
#' \dontrun{
#'   # simple example
#'   medical_detect_phi("Mrs. Smith comes in today complaining of shortness of breath.")
#'   
#'   txt <-c("Mrs. Smith comes in today.",
#'           "She is complaining of shortnesss of breath.")
#'   medical_detect_phi(txt)
#' }
#' @export
detect_medical_phi <-
function(
  text,
  language = "en",
  ...
) {
    bod <- list(Text = text, LanguageCode = language)
    out <- comprehendHTTP(action = "DetectPHI", body = bod, service = "comprehendmedical", ...)
    return(cbind(Index = 0, out$Entities))
}
