% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_phenotype_id_from_genome_seq.R
\name{get_phenotype_id_from_genome_seq}
\alias{get_phenotype_id_from_genome_seq}
\title{Get phenotype from genome sequence}
\usage{
get_phenotype_id_from_genome_seq(
  genome_seq,
  seed_id = FALSE,
  genome_id = FALSE,
  phenotype_binary = FALSE,
  triplestore
)
}
\arguments{
\item{genome_seq}{String of letters or a list of strings.}

\item{seed_id}{Integer (from 1 to 1000), a vector of integer
values, or a logical value. This integer is used for starting the
pseudo-random number generator that represents the environment experiencing a
digital organism. If a logical value is used, TRUE returns data found in all
environments and FALSE (by default) returns only distinct data regardless of
the seed.}

\item{genome_id}{Logical value (TRUE/FALSE) to show/hide genome_id (FALSE by
default).}

\item{phenotype_binary}{Logical value (TRUE/FALSE) to show/hide phenotype_id
in binary notation (FALSE by default).}

\item{triplestore}{Object of class triplestore_access which manages database
access.}
}
\value{
Data frame. Columns: "seed_id" (optional), "genome_id" (optional),
"genome_seq", "phenotype_id", "phenotype_binary" (optional).
}
\description{
Get the phenotype encoded by the instruction sequence
constituting the genome of a digital organism for a list of seeds used for
starting the pseudo-random number generator (i.e., a set of environments).
}
\examples{

# Create triplestore object
triplestore <- triplestore_access$new()

# Set access options
triplestore$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)

# Get sequences for genomes_1 and genome_2
sequence1 <- get_genome_seq_from_genome_id(
  genome_id = 1,
  triplestore = triplestore
)$genome_seq[1]

sequence2 <- get_genome_seq_from_genome_id(
  genome_id = 2,
  triplestore = triplestore
)$genome_seq[1]

# Single genome
get_phenotype_id_from_genome_seq(
  genome_seq = sequence1,
  triplestore = triplestore
)

# More than one genome
get_phenotype_id_from_genome_seq(
  genome_seq = c(sequence1, sequence2),
  genome_id = TRUE,
  phenotype_binary = TRUE,
  triplestore = triplestore
)

# At seed_1 and seed_2
get_phenotype_id_from_genome_seq(
  genome_seq = sequence2,
  seed_id = c(1, 2),
  triplestore = triplestore
)

}
