% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm_detect_frequency.R
\name{stsm_detect_frequency}
\alias{stsm_detect_frequency}
\title{Detect frequency and dates from the data}
\usage{
stsm_detect_frequency(y, freq = NULL)
}
\arguments{
\item{y}{Univariate time series of data values. May also be a 2 column data frame containing a date column.}

\item{freq}{Initial setting for the frequency detection}
}
\value{
List giving the dates and frequency of the data
}
\description{
Detect frequency and dates from the data
}
\examples{
\dontrun{
#GDP Not seasonally adjusted
library(autostsm)
data("NA000334Q", package = "autostsm") #From FRED
NA000334Q = data.table(NA000334Q, keep.rownames = TRUE)
colnames(NA000334Q) = c("date", "y")
NA000334Q[, "date" := as.Date(date)]
NA000334Q[, "y" := as.numeric(y)]
NA000334Q = NA000334Q[date >= "1990-01-01", ]
freq = stsm_detect_frequency(y = NA000334Q)
}
}
