% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_plot.R
\name{log_plot}
\alias{log_plot}
\title{Plot a metric of a process over time}
\usage{
log_plot(log, pid = NULL, name = NULL, phase = NULL, metric = "resident", ...)
}
\arguments{
\item{log}{Data frame returned by \code{\link[=log_read]{log_read()}}. Must be nonempty.
\code{\link[=log_plot]{log_plot()}} only includes rows with status code equal to 0.}

\item{pid}{Either \code{NULL} or a non-negative integer with the process
ID to plot. At least one of \code{pid} or \code{name} must be \code{NULL}.}

\item{name}{Either \code{NULL} or a non-negative integer with the name of
the process to plot. The name was previously specified in the
names of the \code{pid} argument of \code{\link[=log_start]{log_start()}} or \code{\link[=log_print]{log_print()}}.
At least one of \code{pid} or \code{name} must be \code{NULL}.}

\item{phase}{Either \code{NULL} or a character string specifying the
name of a log phase (see \code{\link[=log_phase_set]{log_phase_set()}}).
If not \code{NULL}, then \code{\link[=log_print]{log_print()}} will only visualize data from
the given log phase.}

\item{metric}{Character string with the name of a metric to plot
against time. Must be only a single string.
Defaults to the resident set size (RSS), the total amount of memory
used by the process.
See \code{\link[=log_read]{log_read()}} for descriptions of the metrics available.}

\item{...}{Named optional parameters to pass to the base
function \code{plot()}.}
}
\value{
A base plot of a metric of a log over time.
}
\description{
Visualize a metric of a log over time for a single process ID
in a single log file.
}
\examples{
  path <- tempfile()
  log_start(seconds = 0.25, path = path)
  Sys.sleep(1)
  log_stop()
  Sys.sleep(2)
  log <- log_read(path)
  log_plot(log, metric = "cpu")
  unlink(path)
}
