% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_valence.R
\name{layout_valence}
\alias{layout_valence}
\alias{layout_tbl_graph_valence}
\title{Valence-based layout}
\usage{
layout_valence(
  .data,
  times = 500,
  center = NULL,
  circular = FALSE,
  repulsion_coef = 1,
  attraction_coef = 0.05
)

layout_tbl_graph_valence(
  .data,
  times = 500,
  center = NULL,
  circular = FALSE,
  repulsion_coef = 1,
  attraction_coef = 0.05
)
}
\arguments{
\item{.data}{Some \code{{manynet}} compatible network data.}

\item{times}{Integer of sweeps that the algorithm will pass through.
By default 4.}

\item{center, circular}{Extra parameters required for \code{{tidygraph}}
compatibility.}

\item{repulsion_coef}{Coefficient for global repulsion force.
Default is 1.}

\item{attraction_coef}{Coefficient for edge-based attraction/repulsion force.
Default is 0.05.}
}
\description{
Valence-based layout
}
\examples{
edges <- data.frame(
  from = c("A", "B", "C", "D"),
  to   = c("B", "C", "D", "A"),
  weight = c(2, 3, 1, 4),
  sign = c(1, -1, 1, -1)  # 1 = positive, -1 = negative
  )
graphr(as_igraph(edges), layout="valence")
}
