% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_precision.R
\name{score_one_minus_precision}
\alias{score_one_minus_precision}
\title{One Minus Precision}
\usage{
score_one_minus_precision(object, cutoff = 0.5, data = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{explainer} created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{cutoff}{Treshold value, which divides model predicted values (y_hat) to calculate confusion matrix. By default it's \code{0.5}.}

\item{data}{New data that will be used to calcuate the score. Pass \code{NULL} if you want to use \code{data} from \code{object}.}

\item{...}{Other arguments dependent on the type of score.}
}
\value{
An object of class \code{auditor_score}.
}
\description{
One Minus Precision
}
\examples{
titanic <- na.omit(DALEX::titanic)
titanic$survived <- titanic$survived == "yes"

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)

#create an explainer
exp_glm <- DALEX::explain(model_glm, y = titanic$survived)

# calculate score
score_one_minus_precision(exp_glm)


}
