% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_gini.R
\name{score_one_minus_gini}
\alias{score_one_minus_gini}
\title{One minus Gini Coefficient}
\usage{
score_one_minus_gini(object, data = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{explainer} created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{data}{New data that will be used to calcuate the score. Pass \code{NULL} if you want to use \code{data} from \code{object}.}

\item{...}{Other arguments dependent on the type of score.}
}
\value{
An object of class \code{auditor_score}.
}
\description{
One minus Gini COefficient
100% means perfect equality, where all values are the same.
0 expresses maximal inequality of values.
}
\examples{
titanic <- na.omit(DALEX::titanic)
titanic$survived <- titanic$survived == "yes"

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)

#create an explainer
exp_glm <- DALEX::explain(model_glm, y = titanic$survived)

# calculate score
score_one_minus_gini(exp_glm)


}
