% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-diet-fishbase.R
\name{get_diet_fishbase}
\alias{get_diet_fishbase}
\title{Extract reference for diet information from http:://www.fishbase.se}
\usage{
get_diet_fishbase(fish, mirror = "se")
}
\arguments{
\item{fish}{Vector of fish species with genus and species information.}

\item{mirror}{Character string defining the url mirror to use. Defaults to \code{se}.
In case data extraction is slow use a different mirror. Try to avoid frequently used mirrors
like \code{uk} or \code{com}.}
}
\value{
Dataframe with species, country, locality, linf and k.
}
\description{
This function extracts reference for diet information from http:://www.fishbase.se
}
\examples{
\dontrun{
# For some reason the examples break with appveyor.
fish <- c("Gadus morhua", "Merlangius merlangus", "Maurolicus muelleri")
diet <- get_diet_fishbase(fish)

fish <- c("Gadus morhua", "Merlangius merlangus", "Ammodytes marinus")
diet <- get_diet_fishbase(fish)
}
}
