% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-r-has-capability.R, R/r-has-capability.R
\name{assert_r_can_find_tools}
\alias{assert_r_can_build_translations}
\alias{assert_r_can_compile_code}
\alias{assert_r_can_find_tools}
\alias{r_can_build_translations}
\alias{r_can_compile_code}
\alias{r_can_find_tools}
\title{Can R find tools?}
\usage{
assert_r_can_find_tools()

assert_r_can_compile_code()

assert_r_can_build_translations()

r_can_find_tools(tools)

r_can_compile_code()

r_can_build_translations()
}
\arguments{
\item{tools}{A character vector of tools to look for.}
}
\value{
The \code{is_*} functions return \code{TRUE} if the input is
within an interval.  The \code{assert_*} functions return nothing but
throw an error if the corresponding \code{is_*} function returns
\code{FALSE}.
}
\description{
Checks to see if R can see command line tools.
}
\note{
\code{r_can_compile_code} is a convenience function looking for
\code{gcc} and \code{make}.

\code{r_can_build_translations} is a convenience function looking for
\code{gettext} and \code{msgfmt}.
}
\examples{
r_can_find_tools(c("latex", "pdflatex"))
r_can_compile_code()
r_can_build_translations()
dont_stop(assert_r_can_find_tools(c("latex", "pdflatex")))
dont_stop(assert_r_can_compile_code())
dont_stop(r_can_build_translations())
}
\seealso{
\code{\link[base]{Sys.which}}
}

