% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/assert-is-reflection.R, R/is-reflection.R
\name{assert_is_64_bit_os}
\alias{assert_is_64_bit_os}
\alias{assert_is_bsd}
\alias{assert_is_linux}
\alias{assert_is_mac}
\alias{assert_is_solaris}
\alias{assert_is_unix}
\alias{assert_is_windows}
\alias{is_64_bit_os}
\alias{is_bsd}
\alias{is_linux}
\alias{is_mac}
\alias{is_solaris}
\alias{is_unix}
\alias{is_windows}
\title{What OS is running?}
\usage{
assert_is_64_bit_os()

assert_is_bsd()

assert_is_linux()

assert_is_mac()

assert_is_solaris()

assert_is_unix()

assert_is_windows()

is_64_bit_os()

is_bsd()

is_linux()

is_mac()

is_solaris()

is_unix()

is_windows()
}
\value{
\code{is_windows} returns \code{TRUE} if the OS on the current
platform is Microsoft windows-based.  \code{is_unix} returns \code{TRUE} if
the OS is Unix based (pretty much anything that isn't Windows, including OS
X).
\code{is_mac}, \code{is_linux}, \code{is_bsd}, \code{is_solaris} return
\code{TRUE} if the OS is Apple OS X, Linux, FreeBSD/NetBSD, or Solaris
respectively.
\code{is_64_bit_os} returns \code{TRUE} when the operating system is 64-bit.
The \code{assert_*} functions return nothing but throw an error if the
corresponding \code{is_*} functions return \code{FALSE}.
}
\description{
Is the operating system in this machine Windows/Unix/Mac based.
}
\examples{
is_windows()
is_unix()
is_mac()
is_linux()
is_bsd()
is_solaris()
is_64_bit_os()
dont_stop(assert_is_windows())
dont_stop(assert_is_unix())
}
\references{
With the exception of \code{is_windows} and \code{is_unix} that
use \code{.Platform$OS.type}, the OS is determined from
\code{Sys.info()[["sysname"]]}, which (not on Windows) is calculated via the
OS \code{uname} progam.  GNU has more information on the return value:
\url{https://www.gnu.org/software/libc/manual/html_node/Platform-Type.html}
and Wikipedia has a nice list of possible values:
\url{https://en.wikipedia.org/wiki/Uname#Examples}
}
\seealso{
\code{\link[base]{.Platform}}, \code{\link[base]{Sys.info}} and
\code{\link[base]{version}}.
}

