\name{assert_all_are_nan}
\alias{assert_all_are_nan}
\alias{assert_all_are_not_nan}
\alias{assert_any_are_nan}
\alias{assert_any_are_not_nan}
\alias{is_nan}
\alias{is_not_nan}
\title{Is the input (not) NaN?}
\usage{
  assert_all_are_nan(x)

  assert_any_are_nan(x)

  assert_all_are_not_nan(x)

  assert_any_are_not_nan(x)

  is_nan(x)

  is_not_nan(x)
}
\arguments{
  \item{x}{Input to check.}
}
\value{
  \code{is_nan} wraps \code{is.nan}, coercing the input to
  numeric if necessary.  \code{is_not_nan} works similarly,
  but returns the negation.  The \code{assert_*} functions
  return nothing but throw an error if the corresponding
  \code{is_*} function returns \code{FALSE}.
}
\description{
  Checks to see if the input is a number that is(n't) NaN.
}
\examples{
assert_all_are_not_nan(1:10)
assert_any_are_not_nan(c(NaN, 1))
}
\seealso{
  \code{\link[base]{is.nan}}
}

