% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_functions.R
\name{is_list}
\alias{is_list}
\title{Check if a value is a list}
\usage{
is_list(x, include_dataframes = FALSE)
}
\arguments{
\item{x}{A value to check.}

\item{include_dataframes}{A logical indicating whether data_frames should be considered vectors. Default is \code{FALSE}.}
}
\value{
A logical scalar indicating whether \code{x} is a list.
}
\description{
This function checks if a value is a list.
By default, definition of a 'list' excludes data.frames in spite of them technically being lists.
This behaviour can be changed by setting \code{include_dataframes = TRUE}
}
\examples{
if(interactive()){
is_list(list(1, 2)) # TRUE
is_list(c(1, 2, 3)) # FALSE
is_list(data.frame()) # FALSE
is_list(data.frame(), include_dataframes = TRUE) # TRUE
}
}
\concept{is_type}
