% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_function}
\alias{assert_function}
\title{Assert input is a function}
\usage{
assert_function(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if \code{x} is not a function}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is a function, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert input is a function
}
\examples{
try({
# Assert that a variable is a function
x <- function(a, b) { a + b }
assert_function(x)  # does nothing

# Assert that a variable is not a function
x <- "not a function"
assert_function(x)  # stops execution and prints an error message
})


}
\concept{assert_type}
