% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runLlamaModels.R
\name{runLlamaModels}
\alias{runLlamaModels}
\title{Creates a registry which can be used for running several Llama models on a cluster.}
\usage{
runLlamaModels(asscenarios, feature.steps.list = NULL, baselines = NULL,
  learners = list(), par.sets = list(), rs.iters = 100L,
  n.inner.folds = 2L)
}
\arguments{
\item{asscenarios}{[(list of) \code{\link{ASScenario}}]\cr
Algorithm selection scenarios.}

\item{feature.steps.list}{[\code{list} of \code{character}]\cr
Named list of feature steps we want to use.
Must be named with scenario ids.
Default is to take the default feature steps from the scenario.}

\item{baselines}{[\code{character}]\cr
Vector of characters, defining the baseline models.
Default is c("vbs", "singleBest", "singleBestByPar", "singleBestBySuccesses").}

\item{learners}{[list of \code{\link[mlr]{Learner}}]\cr
mlr learners to use for modeling.
Default is none.}

\item{par.sets}{[list of \code{\link[ParamHelpers]{ParamSet}}]\cr
Param sets for learners to tune via random search.
Pass an empty param set, if you want no tuning.
Must be in of same length as \code{learners} and in the same order.
Default is none.}

\item{rs.iters}{[\code{integer(1)}]\cr
Number of iterations for random search hyperparameter tuning.
Default is 100.}

\item{n.inner.folds}{[\code{integer(1)}]\cr
Number of cross-validation folds for inner CV in hyperparameter tuning.
Default is 2L.}
}
\value{
BatchExperiments registry.
}
\description{
It is likely that you need to install some additional R packages for this from CRAN or extra
Weka learner. The latter can be done via e.g. \code{WPM("install-package", "XMeans")}.

Feature costs are added for real prognostic models but not for baseline models.
}

