% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lik.R
\name{lik_logF}
\alias{lik_logF}
\title{Likelihood object for logF error distribution}
\usage{
lik_logF(df1, df2)
}
\arguments{
\item{df1}{first degree of freedom parameter of F distribution}

\item{df2}{second degree of freedom parameter of F distribution}
}
\description{
Creates a likelihood object for ash for use with logF error distribution
}
\examples{
   e = rnorm(100) + log(rf(100,df1=10,df2=10)) # simulate some data with log(F) error
   ash(e,1,lik=lik_logF(df1=10,df2=10))
}
