% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.tableby.R
\name{as.data.frame.tableby}
\alias{as.data.frame.tableby}
\title{as.data.frame.tableby}
\usage{
\method{as.data.frame}{tableby}(x, ..., title = NULL,
  labelTranslations = NULL, digits = NA, nsmall = NA, nsmall.pct = NA,
  digits.test = NA, test = NA, test.pname = NA, total = NA)
}
\arguments{
\item{x}{An object of class \code{\link{tableby}}.}

\item{...}{Other arguments (not in use at this time).}

\item{title}{Title that will appear on the top of the header in the pretty-table rendering
of the tableby object}

\item{labelTranslations}{A named list (or vector) where the name is the label in the
     output to be replaced in the pretty rendering of tableby by the character string
     value for the named element of the list, e.g., \code{list(age = "Age(Years)", meansd = "Mean(SD)")}.
This applies to both the statistic labels and the variables from the formula.}

\item{digits}{Digits to round for significant digits of numeric, non-integer values.
If \code{digits.test} is not set, \code{digits} is used for that setting.}

\item{nsmall}{Minimum number of digits to the right of the decimal point to display
for floating point numbers.  If \code{NA} (default), it uses the value from
\code{object$control$nsmall}. Allowed non-\code{NA} values are \code{0 <= nsmall <= 20}.}

\item{nsmall.pct}{Minimum number of digits to the right of the decimal point to display
for percent numbers.  If \code{NA} (default), it uses the value from \code{object$control$nsmall.pct}.}

\item{digits.test}{Significant digits by which to round for numeric test statistic p-values,
if the test was performed.}

\item{test}{Logical, denoting whether the "p value" value should be printed.
If \code{NA} (default), it uses the value from \code{object$control$test}.}

\item{test.pname}{Title for p-value (only matters if test is \code{TRUE}; default is "p value").}

\item{total}{Logical, denoting whether to include the "total" value.
If \code{NA} (default), it uses the value from \code{object$control$total}.}
}
\value{
Information is returned as a data.frame of the tableby
}
\description{
Build a data.frame from the tableby object and parameters, and return it
}
\author{
Gregory Dougherty, Jason Sinnwell, Beth Atkinson, adapted from SAS Macros written by Paul Novotny and Ryan Lennon
}
