% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw.R
\name{county_raw}
\alias{county_raw}
\title{Download raw prescription data for specified county (by state and county names) into R}
\usage{
county_raw(county = "Mingo", state = "WV", key = "WaPo")
}
\arguments{
\item{county}{Filter the data to only this county (e.g. 'Mingo')}

\item{state}{Filter the data to county within this state (e.g. 'WV')}

\item{key}{Key needed to make query successful}
}
\description{
Data from from non-contiguous states not yet processed and available.
}
\examples{
\donttest{
library(arcos)

mingo_wv <- county_raw(county = "Mingo", state="WV", key="WaPo")

head(mingo_wv)
}
}
\seealso{
\url{https://www.washingtonpost.com/graphics/2019/investigations/dea-pain-pill-database/#download-resources}

Other raw data: \code{\link{county_raw_fips}},
  \code{\link{pharmacy_raw}}, \code{\link{raw_data}}
}
\concept{raw data}
