% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-requests.R
\name{detect_errors}
\alias{detect_errors}
\title{Detect errors in parsed json response}
\usage{
detect_errors(response, error_call = rlang::caller_env())
}
\arguments{
\item{response}{a \code{\link[httr2:response]{httr2::response}} object.}

\item{error_call}{default \code{\link[rlang:stack]{rlang::caller_env()}}. The environment from which
to throw the error from.}
}
\value{
Nothing. Used for it's side effect. If an error code is encountered in the
response an error is thrown with the error code and the error message.
}
\description{
The requests responses from ArcGIS don't return the status code
in the response itself but rather from the body in the json.
This function checks for the existence of an error. If an error is found,
the contents of the error message are bubbled up.
}
\examples{
\dontrun{
  response <- list(
    error = list(
      code = 400L,
      message = "Unable to generate token.",
      details = "Invalid username or password."
    )
  )

  detect_errors(response)
}
}
\concept{requests}
