% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_worldmodeler_soil_profile.R
\name{get_worldmodeler_apsim_met}
\alias{get_worldmodeler_apsim_met}
\title{Obtain a weather APSIM met from the World Modeler database}
\usage{
get_worldmodeler_apsim_met(
  lonlat,
  dates,
  wrt.dir,
  filenames,
  check = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{lonlat}{Longitude and latitude vector (e.g. c(-93, 42)) or matrix.}

\item{dates}{date range (see example for format)}

\item{wrt.dir}{optional directory where to save a file with \sQuote{met} extension.
If missing it will be written to a temporary directory.}

\item{filenames}{optional name(s) to be used when saving the file. It should be equal to the
number of rows of the input matrix.}

\item{check}{whether to check the met file}

\item{verbose}{argument passed to read_apsim_met}
}
\value{
it creates a list with objects of class \sQuote{met}. 
If it fails, then the objects will be of class \sQuote{try-error}.
}
\description{
Retrieves met data from the World Modeler global database and (optionally) saves it to a file
}
\examples{
\dontrun{
## Get soil profile properties for a single point
  am1 <- get_worldmodeler_apsim_met(lonlat = c(-93, 42), 
                                    dates = c("2010-01-01", "2013-12-31"))
  if(inherits(am1, 'met')){
     plot(am1[[1]], met.var = "rain", cumulative = TRUE)
  }
 }

}
