% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gsod_apsim_met.R
\name{get_gsod_apsim_met}
\alias{get_gsod_apsim_met}
\title{Get GSOD data for an APSIM met file}
\usage{
get_gsod_apsim_met(
  lonlat,
  dates,
  wrt.dir = ".",
  filename = NULL,
  distance = 100,
  fillin.radn = FALSE
)
}
\arguments{
\item{lonlat}{Longitude and latitude vector}

\item{dates}{date ranges}

\item{wrt.dir}{write directory}

\item{filename}{file name for writing out to disk}

\item{distance}{distance in kilometers for the nearest station}

\item{fillin.radn}{whether to fill in radiation data using the nasapower pacakge. Default is FALSE.}
}
\value{
returns an object of class \sQuote{met} and writes a file to disk when filename is supplied.
}
\description{
Uses \code{\link[GSODR]{get_GSOD}} from the \CRANpkg{GSODR} package to download data to create an APSIM met file.
}
\details{
This function requires the \CRANpkg{GSODR} package.

If the filename is not provided it will not write the file to disk, 
but it will return an object of class \sQuote{met}. This is useful in case manipulation
is required before writing to disk.
}
\note{
This source of data does not provide solar radiation. If \sQuote{fillin.radn} is
TRUE it fill in radiation data using the nasapower package.
}
\examples{
\dontrun{
require(GSODR)
## This will not write a file to disk
gsd <- get_gsod_apsim_met(lonlat = c(-93,42), dates = c("2012-01-01","2012-12-31"))
summary(gsd)
## Check for reasonable ranges
## Radiation is not included by default 
check_apsim_met(gsd)
}

}
