% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_apsim_xml.R
\name{inspect_apsim_xml}
\alias{inspect_apsim_xml}
\title{Inspect an APSIM Classic auxiliary (XML) file}
\usage{
inspect_apsim_xml(
  file = "",
  src.dir = ".",
  parm,
  verbose = TRUE,
  print.path = TRUE
)
}
\arguments{
\item{file}{file ending in .xml to be inspected.}

\item{src.dir}{directory containing the .xml file to be inspected; defaults to the current working directory}

\item{parm}{parameter to inspect.}

\item{verbose}{Whether to print to standard output}

\item{print.path}{Whether to print the parameter path}
}
\value{
absolute parameter path
}
\description{
inspect an auxilliary XML apsim file.
}
\examples{
 
\donttest{
extd.dir <- system.file("extdata", package = "apsimx")

inspect_apsim_xml("Maize75.xml", src.dir = extd.dir,
                  parm = "leaf_no_rate_change")
                  
pp <- inspect_apsim_xml("Maize75.xml", src.dir = extd.dir,
                        parm = "leaf_no_rate_change",
                        verbose = FALSE, 
                        print.path = FALSE)
}
}
