% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsim_met.R
\name{write_apsim_met}
\alias{write_apsim_met}
\title{Write an APSIM met file}
\usage{
write_apsim_met(met, wrt.dir = NULL, filename = NULL)
}
\arguments{
\item{met}{object of class \sQuote{met}}

\item{wrt.dir}{directory where the file will be written}

\item{filename}{optional alternative filename}
}
\value{
does not create an R object, it only writes to disk
}
\description{
Write an object of class \sQuote{met} to disk
}
\details{
Write a met file to disk. It takes an object of class \sQuote{met}

at the moment the read-write cycle will strip comments
}
\examples{
\dontrun{
extd.dir <- system.file("extdata", package = "apsimx")
ames.met <- read_apsim_met("Ames.met", src.dir = extd.dir)
ames.met
tmpd <- tempdir()
write_apsim_met(ames.met, wrt.dir = tmpd, filename = "Ames.met")
## Here I write to a temporary directory, but change this to where
## you want to write to
}

}
