% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_varcov.R
\name{apollo_varcov}
\alias{apollo_varcov}
\title{Calculates varcov matrix of an Apollo model}
\usage{
apollo_varcov(apollo_beta, apollo_fixed, varcov_settings)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values of parameters at which to calculate the covariance matrix.
Values _must not be scaled_, and they must include any fixed parameter.}

\item{apollo_fixed}{Character vector. Names of fixed parameters.}

\item{varcov_settings}{List of settings defining the behaviour of this function. It must contain at least one of
teh following: apollo_logLike, apollo_grad or apollo_inputs.
\itemize{
  \item \strong{hessianRoutine}: Character. Name of routine used to calculate 
                                 the Hessian. Valid values are \code{"analytic"}, 
                                 \code{"numDeriv"}, \code{"maxLik"} or \code{"none"} 
                                 to avoid estimating the Hessian and covariance matrix.
  \item \strong{scaleBeta}: Logical. If TRUE (default), parameters are scaled by their 
                            own value before calculating the Hessian to increase numerical
                            stability. However, the output is de-scaled, so they are in 
                            the same scale as the \code{apollo_beta} argument.
  \item \strong{numDeriv_settings}: List. Additional arguments to the Richardson method 
                                    used by numDeriv to calculate the Hessian. See 
                                    argument \code{method.args} in \link[numDeriv]{grad} 
                                    for more details.
  \item \strong{apollo_logLike}: Function to calculate the loglikelihood of the model, as
                                 returned by \link{apollo_makeLogLike}.
  \item \strong{apollo_grad}: Function to calculate the gradient of the model, as
                              returned by \link{apollo_makeGrad}.
  \item \strong{apollo_probabilities}: Function. Likelihood function of the model. 
                                       Must receive three arguments:
                                       \itemize{
                                         \item apollo_beta: Named numeric vector.
                                         \item apollo_inputs: List of settings.
                                         \item functionality: Character.
                                       }
  \item \strong{apollo_inputs}: List of inputs to estimate a model, as returned by 
                                \link{apollo_validateInputs}.
}}
}
\value{
List with the following elements
        \itemize{
          \item \strong{hessian}: Numerical matrix. Hessian of the model at parameter estimates (\code{model$estimate}).
          \item \strong{varcov}: Numerical matrix. Variance-covariance matrix.
          \item \strong{se}: Named numerical vector. Standard errors of parameter estimates.
          \item \strong{corrmat}: Numerical matrix. Correlation between parameter estimates.
          \item \strong{robvarcov}: Numerical matrix. Robust variance-covariance matrix.
          \item \strong{robse}: Named numerical vector. Robust standard errors of parameter estimates.
          \item \strong{robcorrmat}: Numerical matrix. Robust correlation between parameter estimates.
          \item \strong{apollo_beta}: Named numerical vector. Parameter estimates (\code{model$estimate}, not scaled).
          \item \strong{methodUsed}: Character. Name of method used to calculate the Hessian.
          \item \strong{methodsAttempted}: Character vector. Name of methods attempted to calculate the Hessian.
          \item \strong{hessianScaling}: Named numeric vector. Scales used on the paramaters to calculate the Hessian (non-fixed only).
        }
}
\description{
Calculates the Hessian, varcov matrix and s.e. of an Apollo model as defined buy its likelihood function 
and apollo_inputs list of settings. Performs automatic scaling for increased numeric stability.
}
\details{
It calculates the Hessian, variance-covariance, and standard errors at \code{apollo_beta} values of an 
estimated model. At least one of the following settings must be provided (ordered by speed): \code{apollo_grad}, 
\code{apollo_logLike}, or (\code{apollo_probabilities} and \code{apollo_inputs}). If more than one is provided, 
then the priority is: \code{apollo_grad}, \code{apollo_logLike}, (\code{apollo_probabilities} and \code{apollo_inputs}).
}
