% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_saveOutput.R
\name{apollo_saveOutput}
\alias{apollo_saveOutput}
\title{Saves estimation results to files.}
\usage{
apollo_saveOutput(model, saveOutput_settings = NA)
}
\arguments{
\item{model}{Model object. Estimated model object as returned by function \link{apollo_estimate}.}

\item{saveOutput_settings}{List of options. Valid options are the following.
\itemize{
   \item \code{printClassical}: Boolean. TRUE for printing classical standard errors. TRUE by default.
   \item \code{printPVal}: Boolean or Scalar. TRUE or 1 for printing p-values for one-sided test, 2 for printing p-values for two-sided test, FALSE for not printing p-values. FALSE by default.
   \item \code{printT1}: Boolean. If TRUE, t-test for H0: apollo_beta=1 are printed. FALSE by default.
   \item \code{printDataReport}: Boolean. TRUE for printing summary of choices in database and other diagnostics. FALSE by default.
   \item \code{printModelStructure}: Boolean. TRUE for printing model structure. TRUE by default.
   \item \code{printCovar}: Boolean. TRUE for printing parameters covariance matrix. If \code{printClassical=TRUE}, both classical and robust matrices are printed. TRUE by default.
   \item \code{printCorr}: Boolean. TRUE for printing parameters correlation matrix. If \code{printClassical=TRUE}, both classical and robust matrices are printed. TRUE by default.
   \item \code{printOutliers}: Boolean or Scalar. TRUE for printing 20 individuals with worst average fit across observations. FALSE by default. If Scalar is given, this replaces the default of 20.
   \item \code{printChange}: Boolean. TRUE for printing difference between starting values and estimates. TRUE by default.
   \item \code{printFunctions}: Boolean. TRUE for printing apollo_control, apollo_randCoeff (when available), apollo_lcPars (when available) and apollo_probabilities. TRUE by default.                               
   \item \code{saveEst}: Boolean. TRUE for saving estimated parameters and standard errors to a CSV file. TRUE by default.
   \item \code{saveCov}: Boolean. TRUE for saving estimated correlation matrix to a CSV file. FALSE by default.
   \item \code{saveCorr}: Boolean. TRUE for saving estimated correlation matrix to a CSV file. FALSE by default.
   \item \code{saveModelObject}: Boolean. TRUE to save the R model object to a file (use \link{apollo_loadModel} to load it to memory). TRUE by default.
   \item \code{writeF12}: Boolean. TRUE for writing results into an F12 file (ALOGIT format). FALSE by default.
}}
}
\value{
nothing
}
\description{
Writes files in the working directory with the estimation results.
}
\details{
Estimation results are printed to different files in the working directory:
\itemize{
  \item \code{(modelName)_output.txt} Text file with the output produced by function \code{apollo_modelOutput}.
  \item \code{(modelName)_estimates.csv} CSV file with the estimated parameter values, their standars errors, and t-ratios.
  \item \code{(modelName)_covar.csv} CSV file with the estimated classical covariance matrix. Only when bayesian estimation was not used.
  \item \code{(modelName)_robcovar.csv} CSV file with the estimated robust covariance matrix. Only when bayesian estimation was not used.
  \item \code{(modelName)_corr.csv} CSV file with the estimated classical correlation matrix. Only when bayesian estimation was not used.
  \item \code{(modelName)_robcorr.csv} CSV file with the estimated robust correlation matrix. Only when bayesian estimation was not used.
  \item \code{(modelName).F12} F12 file with model results. Compatible with ALOGIT.
}
}
