% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_cppScript.R
\name{apollo_cppScript}
\alias{apollo_cppScript}
\title{Generate C++ function to calculate V}
\usage{
apollo_cppScript(apollo_probabilities, apollo_beta, apollo_inputs, V)
}
\arguments{
\item{apollo_probabilities}{Likelihood function of the whole model.}

\item{apollo_beta}{Named numeric vector of parameters to be estimated.}

\item{apollo_inputs}{List of arguments and settings generated by \link{apollo_validateInputs}.}

\item{V}{Named list of functions.}
}
\value{
A function that receives three arguments:
        \itemize{
          # DataFrame db, NumericVector b, List drw
          \item \code{db}: Data.frame containing observations.
          \item \code{b}: Named numeric vector containing paramters to be estimated.
          \item \code{drw}: Named list containing draws, as contained inside \code{apollo_inputs}.
        }
        And returns a named list with numeric elements.
}
\description{
Returns an R function that calls a C++ function which calculates V efficiently.
}
\details{
V must be a list of functions.
}
