% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_firstRow.R
\name{apollo_firstRow}
\alias{apollo_firstRow}
\title{Keeps only the first row for each individual}
\usage{
apollo_firstRow(P, apollo_inputs)
}
\arguments{
\item{P}{List of vectors, matrices or 3-dim arrays. Likelihood of the model components (or other object).}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}
}
\value{
If \code{P} is a list, then it returns a list where each element has only the first row of each individual.
        If \code{P} is a single element, then it returns a single element with only the first row of each individual.
        The size of the element is changed only in the first dimension. If input is a scalar, then it returns a vector with the element repeated as many
        times as individuals in \code{database}. If the element is a vector, its length will be changed to the number of individuals. If the element is
        a matrix, then its first dimension will be changed to the number of individuals, while keeping the size of the second dimension. If the element 
        is a cube, then only the first dimension's length is changed, preserving the others.
}
\description{
Given a multi-row input, keeps only the first row for each individual.
}
\details{
This a function to keep only the first row of an object per indidividual. It can handle multiple components, scalars, vectors and three-dimensional arrays (cubes).
The argument database MUST contain a column called 'apollo_sequence', which is created by \link{apollo_validateData}.
}
\examples{
database <- data.frame(ID=rep(1:5, each=3), apollo_sequence=rep(1:3, 5))
apollo_inputs <- list(database=database)
attach(database)

P0 <- 0.5
apollo_firstRow(P0, apollo_inputs) 

P1 <- rep(c(0.1, 0.2, 0.3, 0.4, 0.5), each=3)
apollo_firstRow(P1, apollo_inputs) 

P2 <- matrix(rep(P1,10), nrow=15, ncol=10)
apollo_firstRow(P2, apollo_inputs) 

P3 <- array(rep(P1, 10*10), dim=c(15, 10, 10))
apollo_firstRow(P3, apollo_inputs)

P4 <- list(P0, P1, P2, P3)
apollo_firstRow(P4, apollo_inputs)
}
