% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_descriptive_statistics.R
\name{apa.desc}
\alias{apa.desc}
\title{Creates Mean (M) and Standard Deviation (SD) output with confidence interval in APA style using Markdown.}
\usage{
apa.desc(data = NULL, ..., dv = NULL, show.conf.interval = NULL,
  show.N = NULL)
}
\arguments{
\item{data}{Project data frame name}

\item{...}{Tidyverse selection of rows}

\item{dv}{Name of the dependent variable column}

\item{show.conf.interval}{Show confidence interval (default behavior is TRUE)}

\item{show.N}{Show confidence interval (default behavior is TRUE)}
}
\value{
Descriptive statistics (M and SD) in APA style using Markdown
}
\description{
Creates Mean (M) and Standard Deviation (SD) output with confidence interval in APA style using Markdown.
}
\examples{
#2-way ANOVA Example
library(apaTables) #load apaTables to access goggles

#Main Effect Means: Gender
apa.desc(goggles, gender=="Female", dv = attractiveness)
apa.desc(goggles, gender=="Male", dv = attractiveness)

#Main Effect Means: Alcohol
apa.desc(goggles, alcohol=="None", dv = attractiveness)
apa.desc(goggles, alcohol=="2 Pints", dv = attractiveness)
apa.desc(goggles, alcohol=="4 Pints", dv = attractiveness)

#Cell Mean: Female, 2 Pints
apa.desc(goggles, alcohol=="2 Pints", gender=="Female", dv = attractiveness)
}
