% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anomaly_series.R, R/capa.R, R/pass.class.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,anomaly_series-method}
\alias{plot,capa.class-method}
\alias{plot,capa.uv.class-method}
\alias{plot,capa.mv.class-method}
\alias{plot-pass.class}
\alias{plot,pass.class-method}
\title{Visualisation of data, collective and point anomalies.}
\usage{
\S4method{plot}{anomaly_series}(x, xlab = "", ylab = "", ...)

\S4method{plot}{capa.class}(x, subset, variate_names, tile_plot)

\S4method{plot}{capa.uv.class}(x, variate_name)

\S4method{plot}{capa.mv.class}(x, subset, variate_names, tile_plot)

\S4method{plot}{pass.class}(x, subset, variate_names, tile_plot)
}
\arguments{
\item{x}{An S4 class produced by \code{\link{capa}}, \code{\link{capa.uv}}, \code{\link{capa.mv}}.}

\item{xlab}{Character string containing label for the x-axis.}

\item{ylab}{Character string containing label for the y-axis.}

\item{...}{Other parameters to be passed to plotting methods.}

\item{subset}{A numeric vector specifying a subset of the variates to be displayed. Default value is all of the variates present in the data.}

\item{variate_names}{Logical value indicating if variate names should be displayed on the plot. This is useful when a large number of variates are being displayed
as it makes the visualisation easier to interpret. Default value is TRUE.}

\item{tile_plot}{Logical value. If TRUE then a tile plot of the data is produced. The data displayed in the tile plot is normalised to values in [0,1] for each variate.
This type of plot is useful when the data contains are large number of variates. The default value is TRUE if the number of variates is greater than 20.}

\item{variate_name}{Logical value indicating if the variate name should be displayed. Default value is \code{variate.name=TRUE}.}
}
\value{
A ggplot object.
}
\description{
Plot methods for S4 objects returned by \code{\link{capa}}, \code{\link{capa.uv}}, \code{\link{capa.mv}}, and \code{\link{pass}}. 

The plot can either be a line plot or a tile plot, the type produced depending on the options provided to the \code{plot} function and/or the dimensions of the
data associated with the S4 object.
}
\seealso{
\code{\link{capa}},\code{\link{capa.uv}},\code{\link{capa.mv}},\code{\link{pass}}.
}
