% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_apply.R
\name{time_apply}
\alias{time_apply}
\title{Apply a function to a time series by period}
\usage{
time_apply(
  data,
  target,
  period,
  .fun,
  ...,
  start_date = NULL,
  side = "end",
  clean = FALSE,
  message = TRUE
)
}
\arguments{
\item{data}{A \code{tibble} with a date or datetime index.}

\item{target}{A column to apply the function to}

\item{period}{A time-based definition (e.g. "2 weeks").
or a numeric number of observations per frequency (e.g. 10).
See \code{\link[tibbletime:collapse_by]{tibbletime::collapse_by()}} for period notation.}

\item{.fun}{A function to apply (e.g. \code{median})}

\item{...}{Additional parameters passed to the function, \code{.fun}}

\item{start_date}{Optional argument used to
specify the start date for the
first group. The default is to start at the closest period boundary
below the minimum date in the supplied index.}

\item{side}{Whether to return the date at the beginning or the end of
the new period. By default, the "end" of the period.
Use "start" to change to the start of the period.}

\item{clean}{Whether or not to round the collapsed index up / down to the next
period boundary. The decision to round up / down is controlled by the side
argument.}

\item{message}{A boolean. If \code{message = TRUE}, the frequency used is output
along with the units in the scale of the data.}
}
\value{
Returns a \code{tibbletime} object of class \code{tbl_time}.
}
\description{
Apply a function to a time series by period
}
\details{
Uses a time-based period to apply functions to. This is useful in circumstances where you want to
compare the observation values to aggregated values such as \code{mean()} or \code{median()}
during a set time-based period. The returned output extends the
length of the data frame so the differences can easily be computed.
}
\examples{

library(dplyr)

data(tidyverse_cran_downloads)

# Basic Usage
tidyverse_cran_downloads \%>\%
    time_apply(count, period = "1 week", .fun = mean, na.rm = TRUE)

}
