% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_anomalies.R
\name{plot_anomalies}
\alias{plot_anomalies}
\title{Visualize the anomalies in one or multiple time series}
\usage{
plot_anomalies(data, time_recomposed = FALSE, ncol = 1,
  color_no = "#2c3e50", color_yes = "#e31a1c",
  fill_ribbon = "grey70", alpha_dots = 1, alpha_circles = 1,
  alpha_ribbon = 1, size_dots = 1.5, size_circles = 4)
}
\arguments{
\item{data}{A \code{tibble} or \code{tbl_time} object.}

\item{time_recomposed}{A boolean. If \code{TRUE}, will use the \code{time_recompose()} bands to
place bands as approximate limits around the "normal" data.}

\item{ncol}{Number of columns to display. Set to 1 for single column by default.}

\item{color_no}{Color for non-anomalous data.}

\item{color_yes}{Color for anomalous data.}

\item{fill_ribbon}{Fill color for the time_recomposed ribbon.}

\item{alpha_dots}{Controls the transparency of the dots. Reduce when too many dots on the screen.}

\item{alpha_circles}{Controls the transparency of the circles that identify anomalies.}

\item{alpha_ribbon}{Controls the transparency of the time_recomposed ribbon.}

\item{size_dots}{Controls the size of the dots.}

\item{size_circles}{Controls the size of the circles that identify anomalies.}
}
\value{
Returns a \code{ggplot} object.
}
\description{
Visualize the anomalies in one or multiple time series
}
\details{
Plotting function for visualizing anomalies on one or more time series.
Multiple time series must be grouped using \code{dplyr::group_by()}.
}
\examples{

library(dplyr)
library(ggplot2)

data(tidyverse_cran_downloads)

#### SINGLE TIME SERIES ####
tidyverse_cran_downloads \%>\%
    filter(package == "tidyquant") \%>\%
    ungroup() \%>\%
    time_decompose(count, method = "stl") \%>\%
    anomalize(remainder, method = "iqr") \%>\%
    time_recompose() \%>\%
    plot_anomalies(time_recomposed = TRUE)


#### MULTIPLE TIME SERIES ####
tidyverse_cran_downloads \%>\%
    time_decompose(count, method = "stl") \%>\%
    anomalize(remainder, method = "iqr") \%>\%
    time_recompose() \%>\%
    plot_anomalies(time_recomposed = TRUE, ncol = 3)

}
\seealso{
\code{\link[=plot_anomaly_decomposition]{plot_anomaly_decomposition()}}
}
