% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anomalize_methods.R
\name{anomalize_methods}
\alias{anomalize_methods}
\alias{iqr}
\alias{gesd}
\title{Methods that power anomalize()}
\usage{
iqr(x, alpha = 0.05, max_anoms = 0.2, verbose = FALSE)

gesd(x, alpha = 0.05, max_anoms = 0.2, verbose = FALSE)
}
\arguments{
\item{x}{A vector of numeric data.}

\item{alpha}{Controls the width of the "normal" range.
Lower values are more conservative while higher values are less prone
to incorrectly classifying "normal" observations.}

\item{max_anoms}{The maximum percent of anomalies permitted to be identified.}

\item{verbose}{A boolean. If \code{TRUE}, will return a list containing useful information
about the anomalies. If \code{FALSE}, just returns a vector of "Yes" / "No" values.}
}
\value{
Returns character vector or list depending on the value of \code{verbose}.
}
\description{
Methods that power anomalize()
}
\examples{

set.seed(100)
x <- rnorm(100)
idx_outliers <- sample(100, size = 5)
x[idx_outliers] <- x[idx_outliers] + 10

iqr(x, alpha = 0.05, max_anoms = 0.2)
iqr(x, alpha = 0.05, max_anoms = 0.2, verbose = TRUE)

gesd(x, alpha = 0.05, max_anoms = 0.2)
gesd(x, alpha = 0.05, max_anoms = 0.2, verbose = TRUE)


}
\references{
\itemize{
\item The IQR method is used in \href{https://github.com/robjhyndman/forecast/blob/master/R/clean.R}{forecast::tsoutliers()}
\item The GESD method is used in Twitter's \href{https://github.com/twitter/AnomalyDetection}{AnomalyDetection} package and is also available as a function in \href{https://github.com/raunakms/GESD/blob/master/runGESD.R}{@raunakms's GESD method}
}
}
\seealso{
\code{\link[=anomalize]{anomalize()}}
}
