% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_tools.R
\name{vcfanno}
\alias{vcfanno}
\title{R function to run vcfanno}
\usage{
vcfanno(vcfanno = Sys.which(c("vcfanno", "vcfanno_osx", "vcfanno_linux64")),
  vcfanno.database.cfg = system.file("extdata", "demo/vcfanno_demo/conf.toml",
  package = "annovarR"), base_path = "", lua = "", ends = FALSE,
  input.file = "input.vcf", out = "output.vcf", thread = 2,
  permissive_overlap = FALSE, debug = FALSE)
}
\arguments{
\item{vcfanno}{Executable file of vcfanno (Download from https://github.com/brentp/vcfanno/releases)}

\item{vcfanno.database.cfg}{vcfanno required database configuration file 
(Not the annovarR database.cfg)}

\item{base_path}{Optional base_path to prepend to annotation files in the config}

\item{lua}{Optional path to a file containing custom javascript functions to be used as ops}

\item{ends}{Annotate the start and end as well as the interval itself.}

\item{input.file}{Input file path (VCF only)}

\item{out}{Output file path}

\item{thread}{number of processes to use. (default 2)}

\item{permissive_overlap}{annotate with an overlapping variant even it doesn't share the same ref and alt alleles. 
Default is to require exact match between variants.}

\item{debug}{If set TRUE, only print the command}
}
\description{
R function to run vcfanno
}
\examples{
vcfanno(debug = TRUE)
}
