% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto.R
\name{mysql.auto.index}
\alias{mysql.auto.index}
\title{Index annovarR database in mysql (auto from extdata/config/database.toml)}
\usage{
mysql.auto.index(anno.name = "", buildver = "hg19",
  database.dir = "/path/", mysql.connect.params = list(user = "", password =
  "", host = "localhost", port = "3306"), index = "chr_start_index",
  db.type = "mysql", database.cfg = system.file("extdata",
  "config/databases.toml", package = "annovarR"), verbose = TRUE)
}
\arguments{
\item{anno.name}{Annotation name, eg. avsnp138, avsnp147, 1000g2015aug_all}

\item{buildver}{Genome version, hg19, hg38, mm10 and others}

\item{database.dir}{Dir of the databases (mysql no need)}

\item{mysql.connect.params}{Mysql parameters, [host, dbname, table.name, user, password etc.]}

\item{index}{Index name in sqlite}

\item{db.type}{Setting the database type (sqlite, txt or mysql)}

\item{database.cfg}{Configuration file of annovarR databases infomation}

\item{verbose}{Logical indicating wheather print the extra log infomation}
}
\description{
Index annovarR database in mysql (auto from extdata/config/database.toml)
}
\examples{
i <- 'hg19_avsnp147'
database <- system.file('extdata', sprintf('demo/\%s.txt', i), package = 'annovarR')
file.copy(database, sprintf('\%s/\%s.txt', tempdir(), i))
\dontrun{
 mysql.auto.index(anno.name = 'avsnp147', database.dir = tempdir(), 
 mysql.connect.params = list(user = 'username', password = 'password', 
 host = 'localhost', port = 3306, dbname = 'annovarR'))
}
}
