% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_convergence.R
\docType{methods}
\name{testConvergence}
\alias{testConvergence}
\alias{testConvergence,MADproject,numeric-method}
\alias{testConvergence,MADproject,ANY-method}
\title{Test (visually) the convergence of a MADproject object.}
\usage{
testConvergence(proj, dsubset, samples = 1:proj@numSamples, NR = 10,
  NS = 7)

\S4method{testConvergence}{MADproject,numeric}(proj, dsubset,
  samples = 1:proj@numSamples, NR = 10, NS = 7)

\S4method{testConvergence}{MADproject,ANY}(proj, samples, NR, NS)
}
\arguments{
\item{proj}{The MADproject object to be tested.}

\item{dsubset}{The subset of inversion data to use for the likelihood
calculations.}

\item{samples}{A vector of sample IDs to sample from to calculate
likelihood values (defaults to all available in the \code{MADproject} object)}

\item{NR}{The number of different realization totals for which to
calculate likelihood values (defaults to 10)}

\item{NS}{The number of randomly selected samples to test (defaults to 7)
out of \code{samples}}
}
\description{
\code{testConvergence} returns a plot to help the user visualize if
there are enough realizations in the project for converged likelihood
values
}
\section{Methods (by class)}{
\itemize{
\item \code{proj = MADproject,dsubset = numeric}: Tests the convergence using a subset \code{dsubset}
of inversion data \code{zid}

\item \code{proj = MADproject,dsubset = ANY}: Tests the convergence using all inversion data \code{zid}
}}

\examples{
\dontrun{
data(pumping)
testConvergence(pumping, dsubset=1:3)  #Inversion data as time steps 1-3
}

}
