% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WbiplotV2.R
\name{Wbiplot}
\alias{Wbiplot}
\title{Weighted Biplot}
\usage{
Wbiplot(df, numer1, denom1 = 1, numer2, denom2 = 1, cx = 0.5)
}
\arguments{
\item{df}{a dataframe with numeric values only}

\item{numer1}{numerator of first exponent (can be a decimal)}

\item{denom1}{denominator of first exponent (default: 1)}

\item{numer2}{numerator of second exponent (can be a decimal)}

\item{denom2}{denominator of second exponent (default: 1)}

\item{cx}{graphical magnification factor (default: 0.5)}
}
\value{
A biplot of a dataframe with the specified weights.
Weights can either be supplied as two fractions, or as two decimal numbers.
}
\description{
\code{Wbiplot} produces a biplot with any weight distribution between Row and Column markers.
This way the full spectrum from perfect row resolution (Row-metric preserving biplot)
to perfect column resolution (Column-metric preserving biplot) is available.
}
\details{
This function makes use of function \code{Matpow} from package \pkg{powerplus} to
be able to raise any valid matrix (see \code{Matpow} documentation) to any real power between 0 and 1 included.
}
\examples{

require(graphics)

# Exemple 1: Row metric preserving
Wbiplot(USArrests, numer1 = 1, numer2 = 0, cx = 0.6)

# Exemple 2: Column metric preserving
Wbiplot(USArrests, numer1 = 0, numer2 = 1, cx = 0.6)

# Comparison with function \\code{biplot} from package \\pkg{stats}
biplot(princomp(USArrests), cex = 0.6)

# Example 3: Custom, 50-50
Wbiplot(USArrests, numer1 = 0.5, numer2 = 0.5)

# Example 4: Custom, 20-80
Wbiplot(USArrests, numer1 = 0.2, numer2 = 0.8)

}
\seealso{
\code{\link[powerplus]{Matpow}}
}
\author{
Albert Dorador
}
