% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MinstressV4.R
\name{Minstress}
\alias{Minstress}
\title{Better Starting Configuration For Non-Metric MDS}
\usage{
Minstress(x, p, s, k, iter = 5, pb = F, m = "euclidean")
}
\arguments{
\item{x}{a data frame containing numeric values only}

\item{p}{the size of the population of seeds (any positive integer)}

\item{s}{the number of seeds we sample (any positive integer)}

\item{k}{the number of dimensions wanted (any positive integer)}

\item{iter}{a positive integer specifying the number of iterations.}

\item{pb}{a Boolean variable declaring if one wants to display a pogress bar (default: False)}

\item{m}{a string specifying the distance method (default: 'euclidean')}
}
\value{
A list informing about dimensionality, minimum STRESS level found, and best seed found.
One can then use the best seed found to perform non-metric MDS with a better initial configuration (generally).
}
\description{
\code{Minstress} is a heuristic to find better non-metric MDS solutions,
by finding better starting configurations, instead of just using a random one.
}
\details{
This function performs several iterations, each using a different starting seed,
and in turn each one of those iterations performs non-metric MDS many times (typically, thousands or more)
in an attempt to find the best seed (which induces a particular initial configuration) of them all.
}
\examples{

require(MASS)

swiss.x <- as.data.frame(swiss[, -1])
Minstress(swiss.x, 1e5, 50, 2, iter = 3)

# Comparing without using Minstress (for such a low value of s, difference is minimal)
swiss.x <- as.matrix(swiss[, -1])
swiss.dist <- dist(swiss.x)
swiss.mds <- isoMDS(swiss.dist)

}
\author{
Albert Dorador
}
