% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnr_simple.r
\name{gnr_simple}
\alias{gnr_simple}
\title{checks species names against a variety of online databases
supports fuzzy partial matching, using the Global Names Resolver
(https://resolver.globalnames.org/)}
\usage{
gnr_simple(
  name,
  sourceid = NULL,
  best_match = TRUE,
  fuzzy_uninomial = TRUE,
  canonical = TRUE,
  with_context = TRUE,
  higher = FALSE
)
}
\arguments{
\item{name}{character string binomial scientific name to resolve}

\item{sourceid}{integer vector with data source ids.
see https://resolver.globalnames.org/sources/}

\item{best_match}{boolean. Should the best match be returned based on score?}

\item{fuzzy_uninomial}{boolean. Use fuzzy matching for uninomial names?}

\item{canonical}{boolean. return canonical name?}

\item{with_context}{boolean. Return context (auther of species name?)}

\item{higher}{boolean: Return higher taxonomic classifications?}
}
\value{
new data.frame with name matches, column indicating match type
and scores from Global Names Resolver (https://resolver.globalnames.org/).
Will contain a row of NAs if no matches found
}
\description{
Provides convienent output with a single result, using a variety
of criteria for the best match
}
\examples{
#Visit https://resolver.globalnames.org/data_sources to see all possible
#data sources for name checking.
name<-"Aphanazomenon flos-aquae"
#sourceid=3 for ITIS database,195 for Algaebase
gnr_simple(name,sourceid=3) #search for ITIS matches
gnr_simple(name,sourceid=NULL) #search for matches from any source
}
