\name{plot.group}
\alias{plot.group}
%- plot.group.
\title{ Plotting the multiple comparison of means }
\description{
 It plots bars of the averages of treatments to compare.
 It uses the objects generated by a procedure of comparison like LSD, HSD,
 Kruskall, Waller-Duncan, Friedman or Durbin. It can also display the 'average' 
 value over each bar in a bar chart.
}
\usage{
\method{plot}{group}(x,variation=c("range","IQR","SE","SD"), decreasing = TRUE,
              horiz=FALSE,col=NULL,xlim=NULL,ylim=NULL,main=NULL,cex=NULL,hy=0,...)
}
\arguments{
  \item{x}{ Object created by a test of comparison }
  \item{variation}{ in lines by range, IQR, standard deviation or error }
  \item{decreasing}{ Logical, decreasing order of the mean }
  \item{horiz}{ Horizontal or vertical image }  
  \item{col}{line colors}
  \item{xlim}{optional, axis x limits}
  \item{ylim}{optional, axis y limits}
  \item{main}{optional, main title}
  \item{cex}{optional, group label size}
  \item{hy}{optional, default =0, sum group label position}
  \item{\dots}{ Parameters of the function barplot() }
}
\details{
The output is a vector that indicates the position of the treatments on the coordinate axes. 
}

\author{ Felipe de Mendiburu }

\seealso{
  \code{\link{BIB.test}}, \code{\link{DAU.test}}, \code{\link{duncan.test}},
  \code{\link{durbin.test}}, \code{\link{friedman}}, \code{\link{HSD.test}},
  \code{\link{kruskal}}, \code{\link{LSD.test}}, \code{\link{Median.test}}, 
  \code{\link{PBIB.test}}, \code{\link{REGW.test}}, \code{\link{scheffe.test}}, 
  \code{\link{SNK.test}}, \code{\link{waerden.test}}, \code{\link{waller.test}}
}
\examples{
library(agricolae)
data(sweetpotato)
model<-aov(yield~virus,data=sweetpotato)
comparison<- LSD.test(model,"virus",alpha=0.01,group=TRUE)
#startgraph
op<-par(cex=1.5)
plot(comparison,horiz=TRUE,xlim=c(0,50),las=1)
title(cex.main=0.8,main="Comparison between\ntreatment means",xlab="Yield",ylab="Virus")
#endgraph
par(op)
}
\keyword{ aplot }% at least one, from doc/KEYWORDS

