% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{am_pivot_longer}
\alias{am_pivot_longer}
\title{Reshape Column-Based Data to Long Format}
\usage{
am_pivot_longer(
  data,
  id_cols = intersect(c("ISO3", .AMT), names(data)),
  to_value = setdiff(names(data), id_cols),
  variable_name = "Series",
  value_name = "Value",
  label_name = "Label",
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{data}{a wide format data frame where all series have their own column.}

\item{id_cols}{character. Temporal identifiers of the data. By default all variables in \code{\link{.AMT}} and "ISO3" are selected.}

\item{to_value}{character. The names of all series to be stacked into the long format data frame.}

\item{variable_name}{character. The name of the variable to store the names of the series.}

\item{value_name}{character. The name of the variable to store the data values.}

\item{label_name}{character. The name of the variable to store the series labels.}

\item{na.rm}{logical. \code{TRUE} will remove all missing values from the long data frame.}

\item{\dots}{further arguments passed to \code{\link[data.table]{melt}}.}
}
\value{
A \code{\link[data.table]{data.table}} with the reshaped data.
}
\description{
This function automatically reshapes wide (column-based) data into a long format akin to the format of the raw data coming from the database (\code{\link[=am_data]{am_data(..., wide = FALSE)}}).
It can also be used as a general purpose reshaping command - with an additional capability to handle variable labels.
}
\examples{
\donttest{
# Return all indicators for Kenya and Nigeria from the year 2000 onwards
data <- am_data(c("KEN", "NGA"), from = 2000)
am_pivot_longer(data)
}
}
\seealso{
\code{\link{am_pivot_wider}}, \code{\link{africamonitor}}
}
