% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_segments.R
\name{aw_get_segments}
\alias{aw_get_segments}
\title{Get list of segments}
\usage{
aw_get_segments(
  company_id = Sys.getenv("AW_COMPANY_ID"),
  rsids = NA,
  segmentFilter = NA,
  locale = "en_US",
  name = NA,
  tagNames = NA,
  filterByPublishedSegments = "all",
  limit = 10,
  page = 0,
  sortDirection = "ASC",
  sortProperty = "id",
  expansion = NA,
  includeType = "all",
  debug = FALSE
)
}
\arguments{
\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID} exists in \code{.Renviron} or
elsewhere and no \code{company_id} argument is provided, then the \code{AW_COMPANY_ID} value will be used.
Use \code{\link{get_me}} to get a list of available \code{company_id} values.}

\item{rsids}{Filter the list to only include segments tied to a specified RSID or
list of RSIDs. Specify multiple RSIDs as a vector (i.e., "\verb{rsids = c("rsid_1", rsid_2",...rsid_n")}").
Use \code{\link{aw_get_reportsuites}} to get a list of available \code{rsid} values.}

\item{segmentFilter}{Filter list to only include suites in this list of segment IDs (comma-delimited)}

\item{locale}{The locale that segment details should be returned in. The default is \code{en_US}.}

\item{name}{Filter the list to only include segments that contain the specified \strong{name}.
This is case-insensitive and is a simple, single string match.}

\item{tagNames}{Filter the list to only include segments that contain one of the tags.}

\item{filterByPublishedSegments}{Filter the list to only include segments where the published field is set to one of the allowable values:
\code{all} (the default), \code{TRUE}, or \code{FALSE}.}

\item{limit}{The number of results to return per page. This argument works in conjunction with the
\code{page} argument. The default is 10.}

\item{page}{The "page" of results to display. This works in conjunction with the \code{limit} argument and is
zero-based. For instance, if \code{limit = 20} and \code{page = 1}, the results returned would be 21 through 40.}

\item{sortDirection}{The sort direction for the results: \code{ASC} (default) for ascending or \code{DESC} for
descending. (This is case insensitive, so \code{asc} and \code{desc} work as well.)}

\item{sortProperty}{The property to sort the results by. Currently available values are \code{id} (default), \code{name},
and \code{modified_date}. Note that setting \code{expansion = modified} returns results with a column added called
\code{modified}, which is the last date the calculated metric was modified. When using this value for \code{sortProperty},
though, the name of the argument is \code{modified_date}, because why would we expect locked-in consistency
from Adobe?}

\item{expansion}{Additional segment metadata fields to include in the results: \code{reportSuiteName},
\code{ownerFullName}, \code{modified}, \code{tags}, \code{compatibility}, \code{definition}, \code{publishingStatus}, \code{definitionLastModified},
and \code{categories}. This argument takes a single value (e.g., \code{expansion = "modified"})
or a vector of values (e.g., \code{expansion = c("modified", "ownerFullName")}).}

\item{includeType}{Include additional segments not owned by the user. Available values are \code{all} (default),
\code{shared}, and \code{templates}. The \code{all} option takes precedence over "shared".}

\item{debug}{Include the output and input of the api call in the console for debugging. Default is FALSE}
}
\value{
A data frame of segments and their meta data.
}
\description{
Retrieve all segments
}
