% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{io.snp_phased_ancestry}
\alias{io.snp_phased_ancestry}
\title{IO handler for SNP phased, ancestry matrix.}
\usage{
io.snp_phased_ancestry(filename, read_mode = "file")
}
\arguments{
\item{filename}{File name.}

\item{read_mode}{Reading mode.}
}
\value{
IO handler for SNP phased, ancestry data.
}
\description{
IO handler for SNP phased, ancestry matrix.
}
\examples{
n <- 123
s <- 423
A <- 8
filename <- paste(tempdir(), "snp_phased_ancestry_dummy.snpdat", sep="/")
handle <- io.snp_phased_ancestry(filename)
calldata <- matrix(
    as.integer(sample.int(
        2, n * s * 2,
        replace=TRUE,
        prob=c(0.7, 0.3)
    ) - 1),
    n, s * 2
)
ancestries <- matrix(
    as.integer(sample.int(
        A, n * s * 2,
        replace=TRUE,
        prob=rep_len(1/A, A)
    ) - 1),
    n, s * 2
)
handle$write(calldata, ancestries, A, 1)
handle$read()
file.remove(filename)
}
