% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{plot.grpnet}
\alias{plot.grpnet}
\title{plot coefficients from a "grpnet" object}
\usage{
\method{plot}{grpnet}(x, sign.lambda = -1, glm.name = TRUE, ...)
}
\arguments{
\item{x}{fitted \code{"grpnet"} model}

\item{sign.lambda}{This determines whether we plot against \code{log(lambda)} or its negative.
values are \code{-1}(default) or \code{1}}

\item{glm.name}{This is a logical (default \code{TRUE}), and causes the glm name of the model
to be included in the plot.}

\item{\dots}{Other graphical parameters to plot}
}
\description{
Produces a coefficient profile plot of the coefficient paths for a fitted
\code{"grpnet"} object.
}
\details{
A coefficient profile plot is produced. If \code{x} is a multinomial or multigaussian model,
the 2norm of the vector of coefficients is plotted.
}
\examples{
x=matrix(rnorm(100*20),100,20)
y=rnorm(100)
fit1=grpnet(x,glm.gaussian(y))
plot(fit1)
g4=diag(4)[sample(1:4,100,replace=TRUE),]
fit2=grpnet(x,glm.multinomial(g4))
plot(fit2,lwd=3)
fit3=grpnet(x,glm.gaussian(y),groups=c(1,5,9,13,17))
plot(fit3)
}
\references{
Yang, James and Hastie, Trevor. (2024) A Fast and Scalable Pathwise-Solver for Group Lasso
and Elastic Net Penalized Regression via Block-Coordinate Descent. arXiv \doi{10.48550/arXiv.2405.08631}.
}
\seealso{
\code{grpnet}, and \code{print}, and \code{coef} methods, and
\code{cv.grpnet}.
}
\author{
James Yang, Trevor Hastie, and  Balasubramanian Narasimhan \cr Maintainer: Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
\keyword{models}
\keyword{regression}
